/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.awt.Point;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import java.awt.Component;
import java.awt.Container;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import org.openoffice.java.accessibility.AbstractButton;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.Component;

class Button
extends AbstractButton
implements Accessible {
    public Button(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        super(xAccessible, xAccessibleContext);
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleButtonListener();
    }

    public AccessibleContext createAccessibleContext() {
        return new AccessibleButton();
    }

    protected Component getComponent(XAccessible unoAccessible) {
        Component c = AccessibleObjectFactory.getAccessibleComponent(unoAccessible);
        if (c == null) {
            c = AccessibleObjectFactory.createAccessibleComponent(unoAccessible);
            if (c instanceof Accessible) {
                ((Accessible)((Object)c)).getAccessibleContext().setAccessibleParent(this);
            }
            if (c instanceof Container) {
                AccessibleObjectFactory.populateContainer((Container)c, unoAccessible.getAccessibleContext());
            }
        }
        return c;
    }

    protected class AccessibleButton
    extends AbstractButton.AccessibleAbstractButton {
        protected AccessibleButton() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PUSH_BUTTON;
        }

        public int getAccessibleChildrenCount() {
            try {
                return Button.this.unoAccessibleContext.getAccessibleChildCount();
            }
            catch (RuntimeException e) {
                return 0;
            }
        }

        public synchronized Accessible getAccessibleChild(int i) {
            try {
                return (Accessible)((Object)Button.this.getComponent(Button.this.unoAccessibleContext.getAccessibleChild(i)));
            }
            catch (RuntimeException e) {
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            return null;
        }

        public Accessible getAccessibleAt(java.awt.Point p) {
            try {
                Component c = Button.this.getComponent(Button.this.unoAccessibleComponent.getAccessibleAtPoint(new Point(p.x, p.y)));
                return (Accessible)((Object)c);
            }
            catch (RuntimeException e) {
                return null;
            }
        }
    }

    protected class AccessibleButtonListener
    extends Component.AccessibleUNOComponentListener {
        protected AccessibleButtonListener() {
            super(Button.this);
        }

        protected AccessibleContext getContext(Object any) {
            try {
                XAccessible xAccessible = (XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)any);
                Accessible accessible = (Accessible)((Object)Button.this.getComponent(xAccessible));
                return accessible.getAccessibleContext();
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public void notifyEvent(AccessibleEventObject event) {
            switch (event.EventId) {
                case 7: {
                    Component c = Button.this.getComponent(Button.this.unoAccessible);
                    Object[] values = new Object[]{null, null};
                    if (AnyConverter.isObject((Object)event.OldValue)) {
                        values[0] = this.getContext(event.OldValue);
                    }
                    if (AnyConverter.isObject((Object)event.NewValue)) {
                        values[1] = this.getContext(event.NewValue);
                    }
                    Button.this.firePropertyChange("AccessibleChild", values[0], values[1]);
                    break;
                }
                default: {
                    super.notifyEvent(event);
                }
            }
        }
    }
}

