/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.IllegalAccessibleComponentStateException;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventBroadcaster;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleExtendedComponent;
import com.sun.star.accessibility.XAccessibleKeyBinding;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Selection;
import com.sun.star.awt.Size;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.Locale;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.IllegalComponentStateException;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import org.openoffice.java.accessibility.AccessibleKeyBinding;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.AccessibleStateAdapter;
import org.openoffice.java.accessibility.AccessibleTextImpl;

public abstract class Component
extends java.awt.Component {
    public static final Type RectangleType = new Type(Rectangle.class);
    public static final Type SelectionType = new Type(Selection.class);
    protected XAccessible unoAccessible;
    protected XAccessibleContext unoAccessibleContext;
    protected XAccessibleComponent unoAccessibleComponent;
    protected boolean disposed = false;
    protected AccessibleContext accessibleContext = null;

    protected Component(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        this.unoAccessible = xAccessible;
        this.unoAccessibleContext = xAccessibleContext;
        this.unoAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xAccessibleContext);
        XAccessibleEventBroadcaster broadcaster = (XAccessibleEventBroadcaster)UnoRuntime.queryInterface(XAccessibleEventBroadcaster.class, (Object)this.unoAccessibleComponent);
        if (broadcaster != null) {
            broadcaster.addAccessibleEventListener(this.createEventListener());
        }
    }

    public boolean isShowing() {
        if (this.isVisible()) {
            Container parent = this.getParent();
            return parent == null || parent.isShowing();
        }
        return false;
    }

    public void addNotify() {
    }

    public void removeNotify() {
    }

    public void requestFocus() {
    }

    public boolean requestFocus(boolean temporary) {
        return true;
    }

    public boolean requestFocusInWindow() {
        return this.requestFocusInWindow(false);
    }

    protected boolean requestFocusInWindow(boolean temporary) {
        if (this.isFocusable() && this.isVisible()) {
            this.getEventQueue().postEvent(new FocusEvent(this, 1004, temporary));
            return true;
        }
        return false;
    }

    public Object[] getAccessibleComponents(Object[] targetSet) {
        try {
            ArrayList<java.awt.Component> list = new ArrayList<java.awt.Component>(targetSet.length);
            for (int i = 0; i < targetSet.length; ++i) {
                java.awt.Component c = AccessibleObjectFactory.getAccessibleComponent((XAccessible)UnoRuntime.queryInterface(XAccessible.class, (Object)targetSet[i]));
                if (c == null) continue;
                list.add(c);
            }
            list.trimToSize();
            return list.toArray();
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    protected EventQueue getEventQueue() {
        return Toolkit.getDefaultToolkit().getSystemEventQueue();
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        EventQueue.invokeLater(new PropertyChangeBroadcaster(property, oldValue, newValue));
    }

    protected void fireStatePropertyChange(AccessibleState state, boolean set) {
        PropertyChangeBroadcaster broadcaster = set ? new PropertyChangeBroadcaster("AccessibleState", null, state) : new PropertyChangeBroadcaster("AccessibleState", state, null);
        EventQueue.invokeLater(broadcaster);
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleUNOComponentListener();
    }

    protected AccessibleContext createAccessibleContext() {
        return null;
    }

    public final AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            try {
                AccessibleContext ac = this.createAccessibleContext();
                if (ac != null) {
                    ac.setAccessibleName(this.unoAccessibleContext.getAccessibleName());
                    ac.setAccessibleDescription(this.unoAccessibleContext.getAccessibleDescription());
                    this.accessibleContext = ac;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return this.accessibleContext;
    }

    public static Number toNumber(Object any) {
        try {
            if (AnyConverter.isByte((Object)any)) {
                return new Byte(AnyConverter.toByte((Object)any));
            }
            if (AnyConverter.isShort((Object)any)) {
                return new Short(AnyConverter.toShort((Object)any));
            }
            if (AnyConverter.isInt((Object)any)) {
                return new Integer(AnyConverter.toInt((Object)any));
            }
            if (AnyConverter.isLong((Object)any)) {
                return new Long(AnyConverter.toLong((Object)any));
            }
            if (AnyConverter.isFloat((Object)any)) {
                return new Float(AnyConverter.toFloat((Object)any));
            }
            if (AnyConverter.isDouble((Object)any)) {
                return new Double(AnyConverter.toDouble((Object)any));
            }
        }
        catch (IllegalArgumentException e) {
            throw new java.lang.IllegalArgumentException(e.getMessage());
        }
        return null;
    }

    public String toString() {
        return UnoRuntime.generateOid((Object)this.unoAccessible);
    }

    protected abstract class AccessibleUNOComponent
    extends Component.AccessibleAWTComponent
    implements AccessibleExtendedComponent {
        protected ComponentListener accessibleComponentHandler;
        protected FocusListener accessibleFocusHandler;
        protected int propertyChangeListenerCount;

        protected AccessibleUNOComponent() {
            super(Component.this);
            this.accessibleComponentHandler = null;
            this.accessibleFocusHandler = null;
            this.propertyChangeListenerCount = 0;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            if (this.propertyChangeListenerCount++ == 0) {
                this.accessibleComponentHandler = new AccessibleComponentHandler();
                Component.this.addComponentListener(this.accessibleComponentHandler);
                this.accessibleFocusHandler = new AccessibleFocusHandler();
                Component.this.addFocusListener(this.accessibleFocusHandler);
            }
            super.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            if (--this.propertyChangeListenerCount == 0) {
                Component.this.removeComponentListener(this.accessibleComponentHandler);
                this.accessibleComponentHandler = null;
                Component.this.removeFocusListener(this.accessibleFocusHandler);
                this.accessibleFocusHandler = null;
            }
            super.removePropertyChangeListener(listener);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            if (Component.this.disposed) {
                return AccessibleStateAdapter.getDefunctStateSet();
            }
            try {
                return AccessibleStateAdapter.getAccessibleStateSet(Component.this, Component.this.unoAccessibleContext.getAccessibleStateSet());
            }
            catch (RuntimeException e) {
                return AccessibleStateAdapter.getDefunctStateSet();
            }
        }

        public java.util.Locale getLocale() throws IllegalComponentStateException {
            try {
                Locale unoLocale = Component.this.unoAccessible.getAccessibleContext().getLocale();
                return new java.util.Locale(unoLocale.Language, unoLocale.Country);
            }
            catch (IllegalAccessibleComponentStateException e) {
                throw new IllegalComponentStateException(e.getMessage());
            }
            catch (RuntimeException e) {
                return java.util.Locale.getDefault();
            }
        }

        public Color getBackground() {
            try {
                return new Color(Component.this.unoAccessibleComponent.getBackground());
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setBackground(Color c) {
        }

        public Color getForeground() {
            try {
                return new Color(Component.this.unoAccessibleComponent.getForeground());
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setForeground(Color c) {
        }

        public Cursor getCursor() {
            return null;
        }

        public void setCursor(Cursor cursor) {
        }

        public Font getFont() {
            return null;
        }

        public void setFont(Font f) {
        }

        public FontMetrics getFontMetrics(Font f) {
            return null;
        }

        public boolean isEnabled() {
            return Component.this.isEnabled();
        }

        public void setEnabled(boolean b) {
        }

        public boolean isVisible() {
            return Component.this.isVisible();
        }

        public void setVisible(boolean b) {
        }

        public boolean isShowing() {
            return Component.this.isShowing();
        }

        public boolean contains(java.awt.Point p) {
            try {
                return Component.this.unoAccessibleComponent.containsPoint(new Point(p.x, p.y));
            }
            catch (RuntimeException e) {
                return false;
            }
        }

        public java.awt.Point getLocationOnScreen() {
            try {
                Point unoPoint = Component.this.unoAccessibleComponent.getLocationOnScreen();
                return new java.awt.Point(unoPoint.X, unoPoint.Y);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public java.awt.Point getLocation() {
            try {
                Point unoPoint = Component.this.unoAccessibleComponent.getLocation();
                return new java.awt.Point(unoPoint.X, unoPoint.Y);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setLocation(java.awt.Point p) {
        }

        public java.awt.Rectangle getBounds() {
            try {
                Rectangle unoRect = Component.this.unoAccessibleComponent.getBounds();
                return new java.awt.Rectangle(unoRect.X, unoRect.Y, unoRect.Width, unoRect.Height);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setBounds(java.awt.Rectangle r) {
        }

        public Dimension getSize() {
            try {
                Size unoSize = Component.this.unoAccessibleComponent.getSize();
                return new Dimension(unoSize.Width, unoSize.Height);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setSize(Dimension d) {
        }

        public Accessible getAccessibleAt(java.awt.Point p) {
            return null;
        }

        public boolean isFocusTraversable() {
            return Component.this.isFocusable();
        }

        public void requestFocus() {
            Component.this.unoAccessibleComponent.grabFocus();
        }

        public String getToolTipText() {
            try {
                XAccessibleExtendedComponent unoAccessibleExtendedComponent = (XAccessibleExtendedComponent)UnoRuntime.queryInterface(XAccessibleExtendedComponent.class, (Object)Component.this.unoAccessibleComponent);
                if (unoAccessibleExtendedComponent != null) {
                    return unoAccessibleExtendedComponent.getToolTipText();
                }
            }
            catch (RuntimeException e) {
                return null;
            }
            return null;
        }

        public String getTitledBorderText() {
            try {
                XAccessibleExtendedComponent unoAccessibleExtendedComponent = (XAccessibleExtendedComponent)UnoRuntime.queryInterface(XAccessibleExtendedComponent.class, (Object)Component.this.unoAccessibleComponent);
                if (unoAccessibleExtendedComponent != null) {
                    return unoAccessibleExtendedComponent.getTitledBorderText();
                }
            }
            catch (RuntimeException e) {
                return null;
            }
            return null;
        }

        public javax.accessibility.AccessibleKeyBinding getAccessibleKeyBinding() {
            try {
                XAccessibleKeyBinding unoAccessibleKeyBinding;
                XAccessibleAction unoAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, (Object)Component.this.unoAccessibleComponent);
                if (unoAccessibleAction != null && (unoAccessibleKeyBinding = unoAccessibleAction.getAccessibleActionKeyBinding(0)) != null) {
                    return new AccessibleKeyBinding(unoAccessibleKeyBinding);
                }
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
            catch (RuntimeException e) {
                return null;
            }
            return null;
        }

        protected class AccessibleFocusHandler
        implements FocusListener {
            protected AccessibleFocusHandler() {
            }

            public void focusGained(FocusEvent event) {
                AccessibleUNOComponent.this.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                System.err.println("[" + AccessibleUNOComponent.this.getAccessibleRole() + "] " + AccessibleUNOComponent.this.getAccessibleName() + " is now focused");
            }

            public void focusLost(FocusEvent event) {
                AccessibleUNOComponent.this.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                System.err.println("[" + AccessibleUNOComponent.this.getAccessibleRole() + "] " + AccessibleUNOComponent.this.getAccessibleName() + " is no longer focused");
            }
        }

        protected class AccessibleComponentHandler
        implements ComponentListener {
            protected AccessibleComponentHandler() {
            }

            public void componentHidden(ComponentEvent e) {
                AccessibleUNOComponent.this.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }

            public void componentShown(ComponentEvent e) {
                AccessibleUNOComponent.this.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
            }
        }
    }

    protected class AccessibleUNOComponentListener
    implements XAccessibleEventListener {
        protected AccessibleUNOComponentListener() {
        }

        protected void setComponentState(short state, boolean enable) {
            switch (state) {
                case 1: {
                    break;
                }
                case 2: {
                    Component.this.fireStatePropertyChange(AccessibleState.ARMED, enable);
                    break;
                }
                case 4: {
                    Component.this.fireStatePropertyChange(AccessibleState.CHECKED, enable);
                    break;
                }
                case 7: {
                    Component.this.setEnabled(enable);
                    Component.this.fireStatePropertyChange(AccessibleState.ENABLED, enable);
                    break;
                }
                case 11: {
                    Component.this.getEventQueue().postEvent(new FocusEvent(Component.this, enable ? 1004 : 1005));
                    break;
                }
                case 20: {
                    Component.this.fireStatePropertyChange(AccessibleState.PRESSED, enable);
                    break;
                }
                case 23: {
                    Component.this.fireStatePropertyChange(AccessibleState.SELECTED, enable);
                    break;
                }
                case 24: {
                    break;
                }
                case 25: {
                    break;
                }
                case 30: {
                    Component.this.setVisible(enable);
                    break;
                }
                default: {
                    System.err.println("[component]: " + Component.this.getName() + "unexpected state change " + state);
                }
            }
        }

        protected void handleNameChangedEvent(Object any) {
            try {
                if (Component.this.accessibleContext != null) {
                    Component.this.accessibleContext.setAccessibleName(AnyConverter.toString((Object)any));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleDescriptionChangedEvent(Object any) {
            try {
                if (Component.this.accessibleContext != null) {
                    Component.this.accessibleContext.setAccessibleDescription(AnyConverter.toString((Object)any));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleStateChangedEvent(Object any1, Object any2) {
            try {
                if (AnyConverter.isShort((Object)any1)) {
                    this.setComponentState(AnyConverter.toShort((Object)any1), false);
                }
                if (AnyConverter.isShort((Object)any2)) {
                    this.setComponentState(AnyConverter.toShort((Object)any2), true);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void notifyEvent(AccessibleEventObject event) {
            if (!Component.this.disposed) {
                switch (event.EventId) {
                    case 3: {
                        Component.this.firePropertyChange("accessibleActionProperty", Component.toNumber(event.OldValue), Component.toNumber(event.NewValue));
                        break;
                    }
                    case 1: {
                        this.handleNameChangedEvent(event.NewValue);
                        break;
                    }
                    case 2: {
                        this.handleDescriptionChangedEvent(event.NewValue);
                        break;
                    }
                    case 7: {
                        System.out.println("Unexpected child event for object of role " + Component.this.getAccessibleContext().getAccessibleRole());
                        break;
                    }
                    case 4: {
                        this.handleStateChangedEvent(event.OldValue, event.NewValue);
                        break;
                    }
                    case 6: 
                    case 10: {
                        Component.this.firePropertyChange("AccessibleVisibleData", null, null);
                        break;
                    }
                    case 22: {
                        Component.this.firePropertyChange("AccessibleText", AccessibleTextImpl.convertTextSegment(event.OldValue), AccessibleTextImpl.convertTextSegment(event.NewValue));
                        break;
                    }
                    case 21: {
                        Component.this.firePropertyChange("AccessibleSelection", null, null);
                        break;
                    }
                    case 20: {
                        Component.this.firePropertyChange("AccessibleCaret", Component.toNumber(event.OldValue), Component.toNumber(event.NewValue));
                        break;
                    }
                    case 11: {
                        Component.this.firePropertyChange("AccessibleValue", Component.toNumber(event.OldValue), Component.toNumber(event.NewValue));
                    }
                    default: {
                        System.out.println(this + ": unhandled accessibility event id=" + event.EventId);
                    }
                }
            }
        }

        public void disposing(EventObject eventObject) {
            Component.this.disposed = true;
            AccessibleObjectFactory.disposing(Component.this);
        }
    }

    protected class PropertyChangeBroadcaster
    implements Runnable {
        String propertyName;
        Object oldValue;
        Object newValue;

        public PropertyChangeBroadcaster(String name, Object param1, Object param2) {
            this.propertyName = name;
            this.oldValue = param1;
            this.newValue = param2;
        }

        public void run() {
            try {
                AccessibleContext ac = Component.this.accessibleContext;
                if (ac != null) {
                    ac.firePropertyChange(this.propertyName, this.oldValue, this.newValue);
                }
            }
            catch (Exception e) {
                System.err.println(e.getClass().getName() + " caught propagating " + this.propertyName + " event: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

