/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.IllegalAccessibleComponentStateException;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventBroadcaster;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.Locale;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.IllegalComponentStateException;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.AccessibleSelectionImpl;
import org.openoffice.java.accessibility.AccessibleStateAdapter;
import org.openoffice.java.accessibility.AccessibleTextImpl;

public class Container
extends java.awt.Container
implements Accessible {
    protected XAccessible unoAccessible;
    protected XAccessibleContext unoAccessibleContext;
    protected XAccessibleComponent unoAccessibleComponent = null;
    protected AccessibleRole accessibleRole;
    protected AccessibleText accessibleText;
    protected boolean disposed = false;
    protected AccessibleContext accessibleContext = null;

    protected Container(AccessibleRole role, XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        this.accessibleRole = role;
        this.unoAccessible = xAccessible;
        this.unoAccessibleContext = xAccessibleContext;
        this.unoAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xAccessibleContext);
        XAccessibleEventBroadcaster broadcaster = (XAccessibleEventBroadcaster)UnoRuntime.queryInterface(XAccessibleEventBroadcaster.class, (Object)this.unoAccessibleContext);
        if (broadcaster != null) {
            broadcaster.addAccessibleEventListener(this.createEventListener());
        }
    }

    public boolean isShowing() {
        if (this.isVisible()) {
            java.awt.Container parent = this.getParent();
            return parent == null || parent.isShowing();
        }
        return false;
    }

    public void addNotify() {
    }

    public void removeNotify() {
    }

    public void requestFocus() {
    }

    public boolean requestFocus(boolean temporary) {
        return true;
    }

    public boolean requestFocusInWindow() {
        return this.requestFocusInWindow(false);
    }

    protected boolean requestFocusInWindow(boolean temporary) {
        if (this.isFocusable() && this.isVisible()) {
            this.getEventQueue().postEvent(new FocusEvent(this, 1004, temporary));
            return true;
        }
        return false;
    }

    public Object[] getAccessibleComponents(Object[] targetSet) {
        try {
            ArrayList<Component> list = new ArrayList<Component>(targetSet.length);
            for (int i = 0; i < targetSet.length; ++i) {
                Component c = AccessibleObjectFactory.getAccessibleComponent((XAccessible)UnoRuntime.queryInterface(XAccessible.class, (Object)targetSet[i]));
                if (c == null) continue;
                list.add(c);
            }
            list.trimToSize();
            return list.toArray();
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    protected EventQueue getEventQueue() {
        return Toolkit.getDefaultToolkit().getSystemEventQueue();
    }

    protected void firePropertyChange(String property, Object oldValue, Object newValue) {
        EventQueue.invokeLater(new PropertyChangeBroadcaster(property, oldValue, newValue));
    }

    protected void fireStatePropertyChange(AccessibleState state, boolean set) {
        PropertyChangeBroadcaster broadcaster = set ? new PropertyChangeBroadcaster("AccessibleState", null, state) : new PropertyChangeBroadcaster("AccessibleState", state, null);
        EventQueue.invokeLater(broadcaster);
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleContainerListener();
    }

    protected AccessibleContext createAccessibleContext() {
        return new AccessibleContainer();
    }

    public final AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            try {
                AccessibleContext ac = this.createAccessibleContext();
                if (ac != null) {
                    ac.setAccessibleName(this.unoAccessibleContext.getAccessibleName());
                    ac.setAccessibleDescription(this.unoAccessibleContext.getAccessibleDescription());
                    this.accessibleContext = ac;
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return this.accessibleContext;
    }

    public String toString() {
        return UnoRuntime.generateOid((Object)this.unoAccessible);
    }

    protected class AccessibleContainer
    extends Container.AccessibleAWTContainer {
        protected ComponentListener accessibleComponentHandler;
        protected FocusListener accessibleFocusHandler;
        protected ContainerListener accessibleContainerHandler;
        protected int propertyChangeListenerCount;

        protected AccessibleContainer() {
            super(Container.this);
            this.accessibleComponentHandler = null;
            this.accessibleFocusHandler = null;
            this.accessibleContainerHandler = null;
            this.propertyChangeListenerCount = 0;
            Container.this.accessibleText = AccessibleTextImpl.get((XInterface)Container.this.unoAccessibleContext);
        }

        protected AccessibleContainer(boolean query) {
            super(Container.this);
            this.accessibleComponentHandler = null;
            this.accessibleFocusHandler = null;
            this.accessibleContainerHandler = null;
            this.propertyChangeListenerCount = 0;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            if (this.propertyChangeListenerCount++ == 0) {
                this.accessibleFocusHandler = new AccessibleFocusHandler();
                Container.this.addFocusListener(this.accessibleFocusHandler);
                this.accessibleContainerHandler = new AccessibleContainerHandler();
                Container.this.addContainerListener(this.accessibleContainerHandler);
                this.accessibleComponentHandler = new AccessibleComponentHandler();
                Container.this.addComponentListener(this.accessibleComponentHandler);
            }
            super.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            if (--this.propertyChangeListenerCount == 0) {
                Container.this.removeComponentListener(this.accessibleComponentHandler);
                this.accessibleComponentHandler = null;
                Container.this.removeContainerListener(this.accessibleContainerHandler);
                this.accessibleContainerHandler = null;
                Container.this.removeFocusListener(this.accessibleFocusHandler);
                this.accessibleFocusHandler = null;
            }
            super.removePropertyChangeListener(listener);
        }

        public AccessibleRole getAccessibleRole() {
            return Container.this.accessibleRole;
        }

        public AccessibleText getAccessibleText() {
            if (Container.this.disposed) {
                return null;
            }
            return Container.this.accessibleText;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            if (Container.this.disposed) {
                return AccessibleStateAdapter.getDefunctStateSet();
            }
            try {
                return AccessibleStateAdapter.getAccessibleStateSet(Container.this, Container.this.unoAccessibleContext.getAccessibleStateSet());
            }
            catch (RuntimeException e) {
                return AccessibleStateAdapter.getDefunctStateSet();
            }
        }

        public AccessibleSelection getAccessibleSelection() {
            try {
                XAccessibleSelection unoAccessibleSelection = (XAccessibleSelection)UnoRuntime.queryInterface(XAccessibleSelection.class, (Object)Container.this.unoAccessibleContext);
                if (unoAccessibleSelection != null) {
                    return new AccessibleSelectionImpl(unoAccessibleSelection);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return null;
        }

        public java.util.Locale getLocale() throws IllegalComponentStateException {
            try {
                Locale unoLocale = Container.this.unoAccessible.getAccessibleContext().getLocale();
                return new java.util.Locale(unoLocale.Language, unoLocale.Country);
            }
            catch (IllegalAccessibleComponentStateException e) {
                throw new IllegalComponentStateException(e.getMessage());
            }
            catch (RuntimeException e) {
                return super.getLocale();
            }
        }

        public Color getBackground() {
            try {
                return new Color(Container.this.unoAccessibleComponent.getBackground());
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setBackground(Color c) {
        }

        public Color getForeground() {
            try {
                return new Color(Container.this.unoAccessibleComponent.getForeground());
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setForeground(Color c) {
        }

        public Cursor getCursor() {
            return null;
        }

        public void setCursor(Cursor cursor) {
        }

        public Font getFont() {
            return null;
        }

        public void setFont(Font f) {
        }

        public FontMetrics getFontMetrics(Font f) {
            return null;
        }

        public boolean isEnabled() {
            return Container.this.isEnabled();
        }

        public void setEnabled(boolean b) {
        }

        public boolean isVisible() {
            return Container.this.isVisible();
        }

        public void setVisible(boolean b) {
        }

        public boolean isShowing() {
            return Container.this.isShowing();
        }

        public boolean contains(java.awt.Point p) {
            try {
                return Container.this.unoAccessibleComponent.containsPoint(new Point(p.x, p.y));
            }
            catch (RuntimeException e) {
                return false;
            }
        }

        public java.awt.Point getLocationOnScreen() {
            try {
                Point unoPoint = Container.this.unoAccessibleComponent.getLocationOnScreen();
                return new java.awt.Point(unoPoint.X, unoPoint.Y);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public java.awt.Point getLocation() {
            try {
                Point unoPoint = Container.this.unoAccessibleComponent.getLocation();
                return new java.awt.Point(unoPoint.X, unoPoint.Y);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setLocation(java.awt.Point p) {
        }

        public java.awt.Rectangle getBounds() {
            try {
                Rectangle unoRect = Container.this.unoAccessibleComponent.getBounds();
                return new java.awt.Rectangle(unoRect.X, unoRect.Y, unoRect.Width, unoRect.Height);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setBounds(java.awt.Rectangle r) {
        }

        public Dimension getSize() {
            try {
                Size unoSize = Container.this.unoAccessibleComponent.getSize();
                return new Dimension(unoSize.Width, unoSize.Height);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setSize(Dimension d) {
        }

        public Accessible getAccessibleAt(java.awt.Point p) {
            try {
                Component c = AccessibleObjectFactory.getAccessibleComponent(Container.this.unoAccessibleComponent.getAccessibleAtPoint(new Point(p.x, p.y)));
                return (Accessible)((Object)c);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public boolean isFocusTraversable() {
            return Container.this.isFocusable();
        }

        public void requestFocus() {
            Container.this.unoAccessibleComponent.grabFocus();
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            protected AccessibleContainerHandler() {
            }

            public void componentAdded(ContainerEvent e) {
                Component c = e.getChild();
                if (c != null && c instanceof Accessible) {
                    AccessibleContainer.this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)c)).getAccessibleContext());
                }
            }

            public void componentRemoved(ContainerEvent e) {
                Component c = e.getChild();
                if (c != null && c instanceof Accessible) {
                    AccessibleContainer.this.firePropertyChange("AccessibleChild", ((Accessible)((Object)c)).getAccessibleContext(), null);
                }
            }
        }

        protected class AccessibleFocusHandler
        implements FocusListener {
            protected AccessibleFocusHandler() {
            }

            public void focusGained(FocusEvent event) {
                AccessibleContainer.this.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                System.err.println("[" + AccessibleContainer.this.getAccessibleRole() + "] " + AccessibleContainer.this.getAccessibleName() + " is now focused");
            }

            public void focusLost(FocusEvent event) {
                AccessibleContainer.this.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                System.err.println("[" + AccessibleContainer.this.getAccessibleRole() + "] " + AccessibleContainer.this.getAccessibleName() + " is no longer focused");
            }
        }

        protected class AccessibleComponentHandler
        implements ComponentListener {
            protected AccessibleComponentHandler() {
            }

            public void componentHidden(ComponentEvent e) {
                AccessibleContainer.this.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }

            public void componentShown(ComponentEvent e) {
                AccessibleContainer.this.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
            }
        }
    }

    protected class AccessibleContainerListener
    implements XAccessibleEventListener {
        protected AccessibleContainerListener() {
        }

        protected EventQueue getEventQueue() {
            return Toolkit.getDefaultToolkit().getSystemEventQueue();
        }

        protected void setComponentState(short state, boolean enable) {
            switch (state) {
                case 1: {
                    break;
                }
                case 7: {
                    Container.this.setEnabled(enable);
                    Container.this.fireStatePropertyChange(AccessibleState.ENABLED, enable);
                    break;
                }
                case 11: {
                    this.getEventQueue().postEvent(new FocusEvent(Container.this, enable ? 1004 : 1005));
                    break;
                }
                case 23: {
                    Container.this.fireStatePropertyChange(AccessibleState.SELECTED, enable);
                    break;
                }
                case 24: {
                    break;
                }
                case 25: 
                case 30: {
                    Container.this.setVisible(enable);
                    break;
                }
                default: {
                    System.err.println(Container.this + "unexpected state change " + state);
                }
            }
        }

        protected void handleNameChangedEvent(Object any) {
            try {
                if (Container.this.accessibleContext != null) {
                    Container.this.accessibleContext.setAccessibleName(AnyConverter.toString((Object)any));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleDescriptionChangedEvent(Object any) {
            try {
                if (Container.this.accessibleContext != null) {
                    Container.this.accessibleContext.setAccessibleDescription(AnyConverter.toString((Object)any));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleStateChangedEvent(Object any1, Object any2) {
            try {
                if (AnyConverter.isShort((Object)any1)) {
                    this.setComponentState(AnyConverter.toShort((Object)any1), false);
                }
                if (AnyConverter.isShort((Object)any2)) {
                    this.setComponentState(AnyConverter.toShort((Object)any2), true);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleAllChildrenChangedEvent() {
            AccessibleContext parentAC;
            Accessible parent = (Accessible)((Object)Container.this.getParent());
            if (parent != null && (parentAC = parent.getAccessibleContext()) != null) {
                parentAC.firePropertyChange("AccessibleChild", Container.this, null);
                AccessibleObjectFactory.clearContainer(Container.this);
                AccessibleObjectFactory.populateContainer(Container.this, Container.this.unoAccessibleContext);
                parentAC.firePropertyChange("AccessibleChild", null, Container.this);
            }
        }

        public void notifyEvent(AccessibleEventObject event) {
            if (!Container.this.disposed) {
                switch (event.EventId) {
                    case 1: {
                        this.handleNameChangedEvent(event.NewValue);
                        break;
                    }
                    case 2: {
                        this.handleDescriptionChangedEvent(event.NewValue);
                        break;
                    }
                    case 4: {
                        this.handleStateChangedEvent(event.OldValue, event.NewValue);
                        break;
                    }
                    case 22: {
                        Container.this.firePropertyChange("AccessibleText", AccessibleTextImpl.convertTextSegment(event.OldValue), AccessibleTextImpl.convertTextSegment(event.NewValue));
                        break;
                    }
                    case 7: {
                        if (AnyConverter.isObject((Object)event.OldValue)) {
                            AccessibleObjectFactory.removeChild(Container.this, event.OldValue);
                            break;
                        }
                        if (!AnyConverter.isObject((Object)event.NewValue)) break;
                        AccessibleObjectFactory.addChild((java.awt.Container)Container.this, event.NewValue);
                        break;
                    }
                    case 6: 
                    case 10: {
                        Container.this.firePropertyChange("AccessibleVisibleData", null, null);
                        break;
                    }
                    case 9: 
                    case 21: {
                        Container.this.firePropertyChange("AccessibleSelection", null, null);
                        break;
                    }
                    case 8: {
                        this.handleAllChildrenChangedEvent();
                        break;
                    }
                    default: {
                        System.out.println(this + ": unhandled accessibility event id=" + event.EventId);
                    }
                }
            }
        }

        public void disposing(EventObject eventObject) {
            Container.this.disposed = true;
            AccessibleObjectFactory.disposing(Container.this);
        }
    }

    protected class PropertyChangeBroadcaster
    implements Runnable {
        String propertyName;
        Object oldValue;
        Object newValue;

        public PropertyChangeBroadcaster(String name, Object param1, Object param2) {
            this.propertyName = name;
            this.oldValue = param1;
            this.newValue = param2;
        }

        public void run() {
            try {
                AccessibleContext ac = Container.this.accessibleContext;
                if (ac != null) {
                    ac.firePropertyChange(this.propertyName, this.oldValue, this.newValue);
                }
            }
            catch (Exception e) {
                System.err.println(e.getClass().getName() + " caught propagating " + this.propertyName + " event: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

