/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleSelection;
import org.openoffice.java.accessibility.Component;

public abstract class DescendantManager
extends Component {
    protected XAccessibleSelection unoAccessibleSelection = null;
    protected Accessible activeDescendant = null;
    protected boolean multiselectable = false;

    protected DescendantManager(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        super(xAccessible, xAccessibleContext);
    }

    protected DescendantManager(XAccessible xAccessible, XAccessibleContext xAccessibleContext, boolean multiselectable) {
        super(xAccessible, xAccessibleContext);
        this.multiselectable = multiselectable;
    }

    protected abstract class AccessibleDescendantManager
    extends Component.AccessibleUNOComponent
    implements AccessibleSelection {
        protected AccessibleDescendantManager() {
            DescendantManager.this.unoAccessibleSelection = (XAccessibleSelection)UnoRuntime.queryInterface(XAccessibleSelection.class, (Object)DescendantManager.this.unoAccessibleContext);
        }

        public int getAccessibleChildrenCount() {
            try {
                return DescendantManager.this.unoAccessibleContext.getAccessibleChildCount();
            }
            catch (RuntimeException e) {
                return 0;
            }
        }

        public AccessibleSelection getAccessibleSelection() {
            return DescendantManager.this.unoAccessibleSelection != null ? this : null;
        }

        public void addAccessibleSelection(int i) {
            try {
                DescendantManager.this.unoAccessibleSelection.selectAccessibleChild(i);
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        public void clearAccessibleSelection() {
            try {
                DescendantManager.this.unoAccessibleSelection.clearAccessibleSelection();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        public int getAccessibleSelectionCount() {
            try {
                return DescendantManager.this.unoAccessibleSelection.getSelectedAccessibleChildCount();
            }
            catch (RuntimeException e) {
                return 0;
            }
        }

        public boolean isAccessibleChildSelected(int i) {
            try {
                return DescendantManager.this.unoAccessibleSelection.isAccessibleChildSelected(i);
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
            catch (RuntimeException e) {
                return false;
            }
        }

        public void removeAccessibleSelection(int i) {
            try {
                DescendantManager.this.unoAccessibleSelection.deselectAccessibleChild(i);
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        public void selectAllAccessibleSelection() {
            try {
                DescendantManager.this.unoAccessibleSelection.selectAllAccessibleChildren();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    protected class AccessibleDescendantManagerListener
    extends Component.AccessibleUNOComponentListener {
        protected AccessibleDescendantManagerListener() {
            DescendantManager.this.unoAccessibleSelection = (XAccessibleSelection)UnoRuntime.queryInterface(XAccessibleSelection.class, (Object)DescendantManager.this.unoAccessibleContext);
        }

        public void notifyEvent(AccessibleEventObject event) {
            switch (event.EventId) {
                case 9: {
                    DescendantManager.this.firePropertyChange("AccessibleSelection", null, null);
                    break;
                }
                default: {
                    super.notifyEvent(event);
                }
            }
        }
    }
}

