/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleEventBroadcaster;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.NativeFrame;

public class Dialog
extends java.awt.Dialog
implements Accessible,
NativeFrame {
    protected XAccessibleComponent unoAccessibleComponent;
    boolean opened = false;
    boolean visible = false;
    boolean active = false;
    EventQueue eventQueue = null;
    Component initialComponent = null;
    AccessibleContext accessibleContext = null;

    protected Dialog(Frame owner, XAccessibleComponent xAccessibleComponent) {
        super(owner);
        this.initialize(xAccessibleComponent);
    }

    protected Dialog(Frame owner, String name, XAccessibleComponent xAccessibleComponent) {
        super(owner, name);
        this.initialize(xAccessibleComponent);
    }

    protected Dialog(Frame owner, String name, boolean modal, XAccessibleComponent xAccessibleComponent) {
        super(owner, name, modal);
        this.initialize(xAccessibleComponent);
    }

    private void initialize(XAccessibleComponent xAccessibleComponent) {
        this.unoAccessibleComponent = xAccessibleComponent;
        this.eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        XAccessibleEventBroadcaster broadcaster = (XAccessibleEventBroadcaster)UnoRuntime.queryInterface(XAccessibleEventBroadcaster.class, (Object)xAccessibleComponent);
        if (broadcaster != null) {
            broadcaster.addAccessibleEventListener((XAccessibleEventListener)new AccessibleDialogListener());
        }
    }

    public Component getInitialComponent() {
        return this.initialComponent;
    }

    public void setInitialComponent(Component c) {
        this.initialComponent = c;
    }

    public Integer getHWND() {
        return null;
    }

    public boolean isShowing() {
        if (this.isVisible()) {
            Container parent = this.getParent();
            return parent == null || parent.isShowing();
        }
        return false;
    }

    public void addNotify() {
    }

    public void removeNotify() {
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isDisplayable() {
        return true;
    }

    public void setVisible(boolean b) {
        if (this.visible != b) {
            this.visible = b;
            if (b) {
                if (!this.opened) {
                    this.postWindowEvent(200);
                    this.opened = true;
                }
                this.postComponentEvent(102);
            } else {
                this.postComponentEvent(103);
            }
        }
    }

    public void dispose() {
        this.setVisible(false);
        this.postWindowEvent(202);
    }

    protected void postWindowEvent(int i) {
        this.eventQueue.postEvent(new WindowEvent(this, i));
    }

    protected void postComponentEvent(int i) {
        this.eventQueue.postEvent(new ComponentEvent(this, i));
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleDialog();
            this.accessibleContext.setAccessibleName(this.getTitle());
        }
        return this.accessibleContext;
    }

    protected class AccessibleDialog
    extends Dialog.AccessibleAWTDialog {
        protected ComponentListener accessibleComponentHandler;
        protected WindowListener accessibleWindowHandler;
        protected ContainerListener accessibleContainerHandler;
        protected int propertyChangeListenerCount;

        protected AccessibleDialog() {
            super(Dialog.this);
            this.accessibleComponentHandler = null;
            this.accessibleWindowHandler = null;
            this.accessibleContainerHandler = null;
            this.propertyChangeListenerCount = 0;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            if (this.propertyChangeListenerCount++ == 0) {
                this.accessibleWindowHandler = new AccessibleWindowHandler();
                Dialog.this.addWindowListener(this.accessibleWindowHandler);
                this.accessibleContainerHandler = new AccessibleContainerHandler();
                Dialog.this.addContainerListener(this.accessibleContainerHandler);
                this.accessibleComponentHandler = new AccessibleComponentHandler();
                Dialog.this.addComponentListener(this.accessibleComponentHandler);
            }
            super.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            if (--this.propertyChangeListenerCount == 0) {
                Dialog.this.removeComponentListener(this.accessibleComponentHandler);
                this.accessibleComponentHandler = null;
                Dialog.this.removeContainerListener(this.accessibleContainerHandler);
                this.accessibleContainerHandler = null;
                Dialog.this.removeWindowListener(this.accessibleWindowHandler);
                this.accessibleWindowHandler = null;
            }
            super.removePropertyChangeListener(listener);
        }

        public Color getBackground() {
            try {
                return new Color(Dialog.this.unoAccessibleComponent.getBackground());
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setBackground(Color c) {
        }

        public Color getForeground() {
            try {
                return new Color(Dialog.this.unoAccessibleComponent.getForeground());
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setForeground(Color c) {
        }

        public Cursor getCursor() {
            return null;
        }

        public void setCursor(Cursor cursor) {
        }

        public Font getFont() {
            return null;
        }

        public void setFont(Font f) {
        }

        public FontMetrics getFontMetrics(Font f) {
            return null;
        }

        public boolean isEnabled() {
            return Dialog.this.isEnabled();
        }

        public void setEnabled(boolean b) {
        }

        public boolean isVisible() {
            return Dialog.this.isVisible();
        }

        public void setVisible(boolean b) {
        }

        public boolean isShowing() {
            return Dialog.this.isShowing();
        }

        public boolean contains(java.awt.Point p) {
            try {
                return Dialog.this.unoAccessibleComponent.containsPoint(new Point(p.x, p.y));
            }
            catch (RuntimeException e) {
                return false;
            }
        }

        public java.awt.Point getLocationOnScreen() {
            try {
                Point unoPoint = Dialog.this.unoAccessibleComponent.getLocationOnScreen();
                return new java.awt.Point(unoPoint.X, unoPoint.Y);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public java.awt.Point getLocation() {
            try {
                Point unoPoint = Dialog.this.unoAccessibleComponent.getLocation();
                return new java.awt.Point(unoPoint.X, unoPoint.Y);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setLocation(java.awt.Point p) {
        }

        public java.awt.Rectangle getBounds() {
            try {
                Rectangle unoRect = Dialog.this.unoAccessibleComponent.getBounds();
                return new java.awt.Rectangle(unoRect.X, unoRect.Y, unoRect.Width, unoRect.Height);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setBounds(java.awt.Rectangle r) {
        }

        public Dimension getSize() {
            try {
                Size unoSize = Dialog.this.unoAccessibleComponent.getSize();
                return new Dimension(unoSize.Width, unoSize.Height);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setSize(Dimension d) {
        }

        public Accessible getAccessibleAt(java.awt.Point p) {
            try {
                Component c = AccessibleObjectFactory.getAccessibleComponent(Dialog.this.unoAccessibleComponent.getAccessibleAtPoint(new Point(p.x, p.y)));
                return (Accessible)((Object)c);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public boolean isFocusTraversable() {
            return Dialog.this.isFocusable();
        }

        public void requestFocus() {
            Dialog.this.unoAccessibleComponent.grabFocus();
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            protected AccessibleContainerHandler() {
            }

            public void componentAdded(ContainerEvent e) {
                Component c = e.getChild();
                if (c != null && c instanceof Accessible) {
                    AccessibleDialog.this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)c)).getAccessibleContext());
                }
            }

            public void componentRemoved(ContainerEvent e) {
                Component c = e.getChild();
                if (c != null && c instanceof Accessible) {
                    AccessibleDialog.this.firePropertyChange("AccessibleChild", ((Accessible)((Object)c)).getAccessibleContext(), null);
                }
            }
        }

        protected class AccessibleWindowHandler
        implements WindowListener {
            protected AccessibleWindowHandler() {
            }

            public void windowActivated(WindowEvent e) {
                AccessibleDialog.this.firePropertyChange("AccessibleState", null, AccessibleState.ACTIVE);
                System.err.println("[Dialog] " + Dialog.this.getTitle() + " is now active");
            }

            public void windowClosed(WindowEvent e) {
                System.err.println("[Dialog] " + Dialog.this.getTitle() + " has been closed");
            }

            public void windowClosing(WindowEvent e) {
                System.err.println("[Dialog] " + Dialog.this.getTitle() + " is closing");
            }

            public void windowDeactivated(WindowEvent e) {
                AccessibleDialog.this.firePropertyChange("AccessibleState", AccessibleState.ACTIVE, null);
                System.err.println("[Dialog] " + Dialog.this.getTitle() + " is no longer active");
            }

            public void windowDeiconified(WindowEvent e) {
                System.err.println("[Dialog] " + Dialog.this.getTitle() + " has been deiconified");
            }

            public void windowIconified(WindowEvent e) {
                System.err.println("[Dialog] " + Dialog.this.getTitle() + " has been iconified");
            }

            public void windowOpened(WindowEvent e) {
                System.err.println("[Dialog] " + Dialog.this.getTitle() + " has been opened");
            }
        }

        protected class AccessibleComponentHandler
        implements ComponentListener {
            protected AccessibleComponentHandler() {
            }

            public void componentHidden(ComponentEvent e) {
                AccessibleDialog.this.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }

            public void componentShown(ComponentEvent e) {
                AccessibleDialog.this.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
            }
        }
    }

    protected class AccessibleDialogListener
    implements XAccessibleEventListener {
        protected AccessibleDialogListener() {
        }

        protected void setComponentState(short state, boolean enable) {
            switch (state) {
                case 1: {
                    Dialog.this.active = enable;
                    if (enable) {
                        AccessibleObjectFactory.postWindowActivated(Dialog.this);
                        break;
                    }
                    AccessibleObjectFactory.postWindowLostFocus(Dialog.this);
                    break;
                }
                case 13: {
                    Dialog.this.postWindowEvent(enable ? 203 : 204);
                    break;
                }
                case 30: {
                    Dialog.this.setVisible(enable);
                    break;
                }
                default: {
                    System.err.println("[dialog]: " + Dialog.this.getTitle() + "unexpected state change " + state);
                }
            }
        }

        protected void handleNameChangedEvent(Object any) {
            try {
                String title = AnyConverter.toString((Object)any);
                Dialog.this.setTitle(title);
                AccessibleContext ac = Dialog.this.accessibleContext;
                if (ac != null) {
                    ac.setAccessibleName(title);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleDescriptionChangedEvent(Object any) {
            try {
                AccessibleContext ac = Dialog.this.accessibleContext;
                if (ac != null) {
                    ac.setAccessibleDescription(AnyConverter.toString((Object)any));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleStateChangedEvent(Object any1, Object any2) {
            try {
                if (AnyConverter.isShort((Object)any1)) {
                    this.setComponentState(AnyConverter.toShort((Object)any1), false);
                }
                if (AnyConverter.isShort((Object)any2)) {
                    this.setComponentState(AnyConverter.toShort((Object)any2), true);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleVisibleDataEvent() {
            AccessibleContext ac = Dialog.this.accessibleContext;
            if (ac != null) {
                ac.firePropertyChange("AccessibleVisibleData", null, null);
            }
        }

        public void notifyEvent(AccessibleEventObject event) {
            switch (event.EventId) {
                case 1: {
                    this.handleNameChangedEvent(event.NewValue);
                    break;
                }
                case 2: {
                    this.handleDescriptionChangedEvent(event.NewValue);
                    break;
                }
                case 4: {
                    this.handleStateChangedEvent(event.OldValue, event.NewValue);
                    break;
                }
                case 7: {
                    if (AnyConverter.isObject((Object)event.OldValue)) {
                        AccessibleObjectFactory.removeChild(Dialog.this, event.OldValue);
                        break;
                    }
                    if (!AnyConverter.isObject((Object)event.NewValue)) break;
                    AccessibleObjectFactory.addChild((Container)Dialog.this, event.NewValue);
                    break;
                }
                case 6: 
                case 10: {
                    this.handleVisibleDataEvent();
                    break;
                }
                default: {
                    System.out.println(this + ": unhandled accessibility event id=" + event.EventId);
                }
            }
        }

        public void disposing(EventObject eventObject) {
        }
    }
}

