/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleEventBroadcaster;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.NativeFrame;

public class Frame
extends java.awt.Frame
implements Accessible,
NativeFrame {
    protected XAccessibleComponent unoAccessibleComponent;
    boolean opened = false;
    boolean visible = false;
    boolean active = false;
    EventQueue eventQueue = null;
    Component initialComponent = null;
    protected AccessibleContext accessibleContext = null;

    protected Frame(XAccessibleComponent xAccessibleComponent) {
        this.initialize(xAccessibleComponent);
    }

    protected Frame(String name, XAccessibleComponent xAccessibleComponent) {
        super(name);
        this.initialize(xAccessibleComponent);
    }

    private void initialize(XAccessibleComponent xAccessibleComponent) {
        this.unoAccessibleComponent = xAccessibleComponent;
        this.eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        XAccessibleEventBroadcaster broadcaster = (XAccessibleEventBroadcaster)UnoRuntime.queryInterface(XAccessibleEventBroadcaster.class, (Object)this.unoAccessibleComponent);
        if (broadcaster != null) {
            broadcaster.addAccessibleEventListener((XAccessibleEventListener)new AccessibleFrameListener());
        }
    }

    public Component getInitialComponent() {
        return this.initialComponent;
    }

    public void setInitialComponent(Component c) {
        this.initialComponent = c;
    }

    public Integer getHWND() {
        return null;
    }

    public boolean isShowing() {
        if (this.isVisible()) {
            Container parent = this.getParent();
            return parent == null || parent.isShowing();
        }
        return false;
    }

    public void addNotify() {
    }

    public void removeNotify() {
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean b) {
        if (this.visible != b) {
            this.visible = b;
            if (b) {
                if (!this.opened) {
                    this.postWindowEvent(200);
                    this.opened = true;
                }
                this.postComponentEvent(102);
            } else {
                this.postComponentEvent(103);
            }
        }
    }

    public void dispose() {
        this.setVisible(false);
        this.postWindowEvent(202);
    }

    protected void postWindowEvent(int i) {
        this.eventQueue.postEvent(new WindowEvent(this, i));
    }

    protected void postComponentEvent(int i) {
        this.eventQueue.postEvent(new ComponentEvent(this, i));
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleFrame();
            this.accessibleContext.setAccessibleName(this.getTitle());
        }
        return this.accessibleContext;
    }

    public boolean isDisplayable() {
        return true;
    }

    protected class AccessibleFrame
    extends Frame.AccessibleAWTFrame {
        protected ComponentListener accessibleComponentHandler;
        protected WindowListener accessibleWindowHandler;
        protected ContainerListener accessibleContainerHandler;
        protected int propertyChangeListenerCount;

        protected AccessibleFrame() {
            super(Frame.this);
            this.accessibleComponentHandler = null;
            this.accessibleWindowHandler = null;
            this.accessibleContainerHandler = null;
            this.propertyChangeListenerCount = 0;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            if (this.propertyChangeListenerCount++ == 0) {
                this.accessibleWindowHandler = new AccessibleWindowHandler();
                Frame.this.addWindowListener(this.accessibleWindowHandler);
                this.accessibleContainerHandler = new AccessibleContainerHandler();
                Frame.this.addContainerListener(this.accessibleContainerHandler);
                this.accessibleComponentHandler = new AccessibleComponentHandler();
                Frame.this.addComponentListener(this.accessibleComponentHandler);
            }
            super.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            if (--this.propertyChangeListenerCount == 0) {
                Frame.this.removeComponentListener(this.accessibleComponentHandler);
                this.accessibleComponentHandler = null;
                Frame.this.removeContainerListener(this.accessibleContainerHandler);
                this.accessibleContainerHandler = null;
                Frame.this.removeWindowListener(this.accessibleWindowHandler);
                this.accessibleWindowHandler = null;
            }
            super.removePropertyChangeListener(listener);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if ((Frame.this.getExtendedState() & 1) > 0) {
                states.add(AccessibleState.ICONIFIED);
            }
            return states;
        }

        public Color getBackground() {
            try {
                return new Color(Frame.this.unoAccessibleComponent.getBackground());
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setBackground(Color c) {
        }

        public Color getForeground() {
            try {
                return new Color(Frame.this.unoAccessibleComponent.getForeground());
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setForeground(Color c) {
        }

        public Cursor getCursor() {
            return null;
        }

        public void setCursor(Cursor cursor) {
        }

        public Font getFont() {
            return null;
        }

        public void setFont(Font f) {
        }

        public FontMetrics getFontMetrics(Font f) {
            return null;
        }

        public boolean isEnabled() {
            return Frame.this.isEnabled();
        }

        public void setEnabled(boolean b) {
        }

        public boolean isVisible() {
            return Frame.this.isVisible();
        }

        public void setVisible(boolean b) {
        }

        public boolean isShowing() {
            return Frame.this.isShowing();
        }

        public boolean contains(java.awt.Point p) {
            try {
                return Frame.this.unoAccessibleComponent.containsPoint(new Point(p.x, p.y));
            }
            catch (RuntimeException e) {
                return false;
            }
        }

        public java.awt.Point getLocationOnScreen() {
            try {
                Point unoPoint = Frame.this.unoAccessibleComponent.getLocationOnScreen();
                return new java.awt.Point(unoPoint.X, unoPoint.Y);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public java.awt.Point getLocation() {
            try {
                Point unoPoint = Frame.this.unoAccessibleComponent.getLocation();
                return new java.awt.Point(unoPoint.X, unoPoint.Y);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setLocation(java.awt.Point p) {
        }

        public java.awt.Rectangle getBounds() {
            try {
                Rectangle unoRect = Frame.this.unoAccessibleComponent.getBounds();
                return new java.awt.Rectangle(unoRect.X, unoRect.Y, unoRect.Width, unoRect.Height);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setBounds(java.awt.Rectangle r) {
        }

        public Dimension getSize() {
            try {
                Size unoSize = Frame.this.unoAccessibleComponent.getSize();
                return new Dimension(unoSize.Width, unoSize.Height);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setSize(Dimension d) {
        }

        public Accessible getAccessibleAt(java.awt.Point p) {
            try {
                Component c = AccessibleObjectFactory.getAccessibleComponent(Frame.this.unoAccessibleComponent.getAccessibleAtPoint(new Point(p.x, p.y)));
                return (Accessible)((Object)c);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public boolean isFocusTraversable() {
            return Frame.this.isFocusable();
        }

        public void requestFocus() {
            Frame.this.unoAccessibleComponent.grabFocus();
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            protected AccessibleContainerHandler() {
            }

            public void componentAdded(ContainerEvent e) {
                Component c = e.getChild();
                if (c != null && c instanceof Accessible) {
                    AccessibleFrame.this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)c)).getAccessibleContext());
                }
            }

            public void componentRemoved(ContainerEvent e) {
                Component c = e.getChild();
                if (c != null && c instanceof Accessible) {
                    AccessibleFrame.this.firePropertyChange("AccessibleChild", ((Accessible)((Object)c)).getAccessibleContext(), null);
                }
            }
        }

        protected class AccessibleWindowHandler
        implements WindowListener {
            protected AccessibleWindowHandler() {
            }

            public void windowActivated(WindowEvent e) {
                AccessibleFrame.this.firePropertyChange("AccessibleState", null, AccessibleState.ACTIVE);
                System.err.println("[frame] " + Frame.this.getTitle() + " is now active");
            }

            public void windowClosed(WindowEvent e) {
                System.err.println("[frame] " + Frame.this.getTitle() + " has been closed");
            }

            public void windowClosing(WindowEvent e) {
                System.err.println("[frame] " + Frame.this.getTitle() + " is closing");
            }

            public void windowDeactivated(WindowEvent e) {
                AccessibleFrame.this.firePropertyChange("AccessibleState", AccessibleState.ACTIVE, null);
                System.err.println("[frame] " + Frame.this.getTitle() + " is no longer active");
            }

            public void windowDeiconified(WindowEvent e) {
                System.err.println("[frame] " + Frame.this.getTitle() + " is no longer iconified");
            }

            public void windowIconified(WindowEvent e) {
                System.err.println("[frame] " + Frame.this.getTitle() + " has been iconified");
            }

            public void windowOpened(WindowEvent e) {
                System.err.println("[frame] " + Frame.this.getTitle() + " has been opened");
            }
        }

        protected class AccessibleComponentHandler
        implements ComponentListener {
            protected AccessibleComponentHandler() {
            }

            public void componentHidden(ComponentEvent e) {
                AccessibleFrame.this.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }

            public void componentShown(ComponentEvent e) {
                AccessibleFrame.this.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
            }
        }
    }

    protected class AccessibleFrameListener
    implements XAccessibleEventListener {
        protected AccessibleFrameListener() {
        }

        protected void setComponentState(short state, boolean enable) {
            switch (state) {
                case 1: {
                    Frame.this.active = enable;
                    if (enable) {
                        AccessibleObjectFactory.postWindowActivated(Frame.this);
                        break;
                    }
                    AccessibleObjectFactory.postWindowLostFocus(Frame.this);
                    break;
                }
                case 13: {
                    System.err.println("[frame]" + Frame.this.getTitle() + (enable ? " is now " : " is no longer ") + "iconified");
                    Frame.this.postWindowEvent(enable ? 203 : 204);
                    break;
                }
                case 30: {
                    Frame.this.setVisible(enable);
                    break;
                }
                default: {
                    System.err.println("[frame]: " + Frame.this.getTitle() + "unexpected state change " + state);
                }
            }
        }

        protected void handleNameChangedEvent(Object any) {
            try {
                String title = AnyConverter.toString((Object)any);
                Frame.this.setTitle(title);
                AccessibleContext ac = Frame.this.accessibleContext;
                if (ac != null) {
                    ac.setAccessibleName(title);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleDescriptionChangedEvent(Object any) {
            try {
                AccessibleContext ac = Frame.this.accessibleContext;
                if (ac != null) {
                    ac.setAccessibleDescription(AnyConverter.toString((Object)any));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleStateChangedEvent(Object any1, Object any2) {
            try {
                if (AnyConverter.isShort((Object)any1)) {
                    this.setComponentState(AnyConverter.toShort((Object)any1), false);
                }
                if (AnyConverter.isShort((Object)any2)) {
                    this.setComponentState(AnyConverter.toShort((Object)any2), true);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleVisibleDataEvent() {
            AccessibleContext ac = Frame.this.accessibleContext;
            if (ac != null) {
                ac.firePropertyChange("AccessibleVisibleData", null, null);
            }
        }

        public void notifyEvent(AccessibleEventObject event) {
            switch (event.EventId) {
                case 1: {
                    this.handleNameChangedEvent(event.NewValue);
                    break;
                }
                case 2: {
                    this.handleDescriptionChangedEvent(event.NewValue);
                    break;
                }
                case 4: {
                    this.handleStateChangedEvent(event.OldValue, event.NewValue);
                    break;
                }
                case 7: {
                    if (AnyConverter.isObject((Object)event.OldValue)) {
                        AccessibleObjectFactory.removeChild(Frame.this, event.OldValue);
                        break;
                    }
                    if (!AnyConverter.isObject((Object)event.NewValue)) break;
                    AccessibleObjectFactory.addChild((Container)Frame.this, event.NewValue);
                    break;
                }
                case 6: 
                case 10: {
                    this.handleVisibleDataEvent();
                    break;
                }
                default: {
                    System.out.println(this + ": unhandled accessibility event id=" + event.EventId);
                }
            }
        }

        public void disposing(EventObject eventObject) {
        }
    }
}

