/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.IllegalAccessibleComponentStateException;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleImage;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.accessibility.XAccessibleValue;
import com.sun.star.awt.Point;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.Locale;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import org.openoffice.java.accessibility.AccessibleActionImpl;
import org.openoffice.java.accessibility.AccessibleComponentImpl;
import org.openoffice.java.accessibility.AccessibleIconImpl;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.AccessibleRoleAdapter;
import org.openoffice.java.accessibility.AccessibleStateAdapter;
import org.openoffice.java.accessibility.AccessibleTextImpl;
import org.openoffice.java.accessibility.AccessibleValueImpl;
import org.openoffice.java.accessibility.DescendantManager;

public class List
extends DescendantManager
implements Accessible {
    protected List(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        super(xAccessible, xAccessibleContext);
    }

    protected void setActiveDescendant(Accessible descendant) {
        Accessible oldAD = this.activeDescendant;
        this.activeDescendant = descendant;
        this.firePropertyChange("AccessibleActiveDescendant", oldAD, descendant);
    }

    protected void setActiveDescendant(Object any) {
        ListItem descendant = null;
        try {
            XAccessible unoAccessible;
            if (AnyConverter.isObject((Object)any) && (unoAccessible = (XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)any)) != null) {
                descendant = new ListItem(unoAccessible);
                try {
                    System.err.println("[List] retrieved active descendant event: new descendant is " + unoAccessible.getAccessibleContext().getAccessibleName());
                }
                catch (NullPointerException e) {
                    System.err.println("*** ERROR *** new active descendant not accessible");
                }
            }
            this.setActiveDescendant(descendant);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void add(XAccessible unoAccessible) {
        if (unoAccessible != null) {
            ListItem item = new ListItem(unoAccessible);
            this.firePropertyChange("AccessibleChild", null, item.getAccessibleContext());
        }
    }

    protected void remove(XAccessible unoAccessible) {
        if (unoAccessible != null) {
            ListItem item = new ListItem(unoAccessible);
            this.firePropertyChange("AccessibleChild", item.getAccessibleContext(), null);
        }
    }

    protected void add(Object any) {
        try {
            this.add((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)any));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void remove(Object any) {
        try {
            this.remove((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)any));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleListListener();
    }

    public AccessibleContext createAccessibleContext() {
        return new AccessibleList();
    }

    class ListItem
    extends Component
    implements Accessible {
        protected XAccessible unoAccessible;
        AccessibleContext accessibleContext = null;

        public ListItem(XAccessible xAccessible) {
            this.unoAccessible = xAccessible;
        }

        public Object[] create(Object[] targetSet) {
            try {
                ArrayList<ListItem> list = new ArrayList<ListItem>(targetSet.length);
                for (int i = 0; i < targetSet.length; ++i) {
                    XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface(XAccessible.class, (Object)targetSet[i]);
                    if (xAccessible == null) continue;
                    list.add(new ListItem(xAccessible));
                }
                list.trimToSize();
                return list.toArray();
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                try {
                    XAccessibleContext xAccessibleContext = this.unoAccessible.getAccessibleContext();
                    if (xAccessibleContext != null) {
                        AccessibleListItem ac = new AccessibleListItem(xAccessibleContext);
                        ac.setAccessibleParent(List.this);
                        this.accessibleContext = ac;
                        AccessibleStateAdapter.setComponentState(this, xAccessibleContext.getAccessibleStateSet());
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return this.accessibleContext;
        }

        protected class AccessibleListItem
        extends AccessibleContext {
            XAccessibleContext unoAccessibleContext;

            public AccessibleListItem(XAccessibleContext xAccessibleContext) {
                this.unoAccessibleContext = xAccessibleContext;
            }

            public String getAccessibleName() {
                try {
                    return this.unoAccessibleContext.getAccessibleName();
                }
                catch (RuntimeException e) {
                    return null;
                }
            }

            public void setAccessibleName(String name) {
            }

            public String getAccessibleDescription() {
                try {
                    return this.unoAccessibleContext.getAccessibleDescription();
                }
                catch (RuntimeException e) {
                    return null;
                }
            }

            public void setAccessibleDescription(String name) {
            }

            public AccessibleRole getAccessibleRole() {
                try {
                    AccessibleRole role = AccessibleRoleAdapter.getAccessibleRole(this.unoAccessibleContext.getAccessibleRole());
                    return role != null ? role : AccessibleRole.LABEL;
                }
                catch (RuntimeException e) {
                    return null;
                }
            }

            public java.util.Locale getLocale() throws IllegalComponentStateException {
                try {
                    Locale unoLocale = this.unoAccessibleContext.getLocale();
                    return new java.util.Locale(unoLocale.Language, unoLocale.Country);
                }
                catch (IllegalAccessibleComponentStateException e) {
                    throw new IllegalComponentStateException(e.getMessage());
                }
                catch (RuntimeException e) {
                    return List.this.getLocale();
                }
            }

            public int getAccessibleIndexInParent() {
                try {
                    return this.unoAccessibleContext.getAccessibleIndexInParent();
                }
                catch (RuntimeException e) {
                    return -1;
                }
            }

            public int getAccessibleChildrenCount() {
                try {
                    return this.unoAccessibleContext.getAccessibleChildCount();
                }
                catch (RuntimeException e) {
                    return 0;
                }
            }

            public Accessible getAccessibleChild(int i) {
                Accessible child = null;
                try {
                    XAccessible xAccessible = this.unoAccessibleContext.getAccessibleChild(i);
                    Accessible activeDescendant = List.this.activeDescendant;
                    if (activeDescendant instanceof ListItem && ((ListItem)activeDescendant).unoAccessible.equals(xAccessible)) {
                        child = activeDescendant;
                    } else if (xAccessible != null) {
                        child = new ListItem(xAccessible);
                    }
                }
                catch (IndexOutOfBoundsException e) {
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return child;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                try {
                    return AccessibleStateAdapter.getAccessibleStateSet(ListItem.this, this.unoAccessibleContext.getAccessibleStateSet());
                }
                catch (RuntimeException e) {
                    return AccessibleStateAdapter.getDefunctStateSet();
                }
            }

            public AccessibleComponent getAccessibleComponent() {
                try {
                    XAccessibleComponent unoAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)this.unoAccessibleContext);
                    return unoAccessibleComponent != null ? new AccessibleComponentImpl(unoAccessibleComponent) : null;
                }
                catch (RuntimeException e) {
                    return null;
                }
            }

            public AccessibleAction getAccessibleAction() {
                try {
                    XAccessibleAction unoAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, (Object)this.unoAccessibleContext);
                    return unoAccessibleAction != null ? new AccessibleActionImpl(unoAccessibleAction) : null;
                }
                catch (RuntimeException e) {
                    return null;
                }
            }

            public AccessibleText getAccessibleText() {
                if (List.this.disposed) {
                    return null;
                }
                try {
                    XAccessibleText unoAccessibleText = (XAccessibleText)UnoRuntime.queryInterface(XAccessibleText.class, (Object)this.unoAccessibleContext);
                    return unoAccessibleText != null ? new AccessibleTextImpl(unoAccessibleText) : null;
                }
                catch (RuntimeException e) {
                    return null;
                }
            }

            public AccessibleValue getAccessibleValue() {
                try {
                    XAccessibleValue unoAccessibleValue = (XAccessibleValue)UnoRuntime.queryInterface(XAccessibleValue.class, (Object)this.unoAccessibleContext);
                    return unoAccessibleValue != null ? new AccessibleValueImpl(unoAccessibleValue) : null;
                }
                catch (RuntimeException e) {
                    return null;
                }
            }

            public AccessibleIcon[] getAccessibleIcon() {
                try {
                    XAccessibleImage unoAccessibleImage = (XAccessibleImage)UnoRuntime.queryInterface(XAccessibleImage.class, (Object)this.unoAccessibleContext);
                    if (unoAccessibleImage != null) {
                        AccessibleIcon[] icons = new AccessibleIcon[]{new AccessibleIconImpl(unoAccessibleImage)};
                        return icons;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return null;
            }
        }
    }

    protected class AccessibleList
    extends DescendantManager.AccessibleDescendantManager {
        protected AccessibleList() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        public Accessible getAccessibleChild(int i) {
            Accessible child = null;
            try {
                XAccessible xAccessible = List.this.unoAccessibleContext.getAccessibleChild(i);
                if (xAccessible != null) {
                    Accessible activeDescendant = List.this.activeDescendant;
                    child = activeDescendant instanceof ListItem && xAccessible.equals(((ListItem)activeDescendant).unoAccessible) ? activeDescendant : new ListItem(xAccessible);
                }
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return child;
        }

        public Accessible getAccessibleAt(java.awt.Point p) {
            Accessible child = null;
            try {
                XAccessible xAccessible = List.this.unoAccessibleComponent.getAccessibleAtPoint(new Point(p.x, p.y));
                if (xAccessible != null) {
                    Accessible activeDescendant = List.this.activeDescendant;
                    child = activeDescendant instanceof ListItem && xAccessible.equals(((ListItem)activeDescendant).unoAccessible) ? activeDescendant : new ListItem(xAccessible);
                }
                return child;
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public Accessible getAccessibleSelection(int i) {
            Accessible child = null;
            try {
                XAccessible xAccessible = List.this.unoAccessibleSelection.getSelectedAccessibleChild(i);
                if (xAccessible != null) {
                    Accessible activeDescendant = List.this.activeDescendant;
                    child = activeDescendant instanceof ListItem && xAccessible.equals(((ListItem)activeDescendant).unoAccessible) ? activeDescendant : new ListItem(xAccessible);
                } else {
                    System.out.println(i + "th selected child is not accessible");
                }
            }
            catch (IndexOutOfBoundsException e) {
                System.err.println("IndexOutOfBoundsException caught for AccessibleList.getAccessibleSelection(" + i + ")");
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return child;
        }
    }

    protected class AccessibleListListener
    extends DescendantManager.AccessibleDescendantManagerListener {
        protected AccessibleListListener() {
        }

        public void notifyEvent(AccessibleEventObject event) {
            switch (event.EventId) {
                case 5: {
                    List.this.setActiveDescendant(event.NewValue);
                    break;
                }
                case 7: {
                    if (AnyConverter.isObject((Object)event.OldValue)) {
                        List.this.remove(event.OldValue);
                    }
                    if (!AnyConverter.isObject((Object)event.NewValue)) break;
                    List.this.add(event.NewValue);
                    break;
                }
                case 8: {
                    break;
                }
                default: {
                    super.notifyEvent(event);
                }
            }
        }
    }
}

