/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.awt.Point;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.awt.Component;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import org.openoffice.java.accessibility.AbstractButton;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.Component;
import org.openoffice.java.accessibility.MenuItem;

public class Menu
extends AbstractButton
implements Accessible {
    private ArrayList<Component> children;
    protected XAccessibleSelection unoAccessibleSelection = null;

    protected Menu(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        super(xAccessible, xAccessibleContext);
        try {
            int count = this.unoAccessibleContext.getAccessibleChildCount();
            this.children = new ArrayList(count);
            for (int i = 0; i < count; ++i) {
                Component c = this.getComponent(this.unoAccessibleContext.getAccessibleChild(i));
                if (c == null) continue;
                this.children.add(c);
            }
        }
        catch (RuntimeException e) {
            System.err.println("RuntimeException caught during menu initialization: " + e.getMessage());
            if (this.children == null) {
                this.children = new ArrayList(0);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected synchronized void add(XAccessible unoAccessible) {
        Component c = this.getComponent(unoAccessible);
        if (c != null) {
            try {
                this.children.add(unoAccessible.getAccessibleContext().getAccessibleIndexInParent(), c);
                this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)c)).getAccessibleContext());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    protected synchronized void remove(XAccessible unoAccessible) {
        Component c = this.getComponent(unoAccessible);
        if (c != null) {
            try {
                this.children.remove(c);
                this.firePropertyChange("AccessibleChild", ((Accessible)((Object)c)).getAccessibleContext(), null);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    protected void add(Object any) {
        try {
            this.add((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)any));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void remove(Object any) {
        try {
            this.remove((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)any));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected synchronized int indexOf(Object child) {
        return this.children.indexOf(child);
    }

    protected Component getComponent(XAccessible unoAccessible) {
        Component c = AccessibleObjectFactory.getAccessibleComponent(unoAccessible);
        if (c == null && (c = AccessibleObjectFactory.createAccessibleComponent(unoAccessible)) instanceof Accessible) {
            ((Accessible)((Object)c)).getAccessibleContext().setAccessibleParent(this);
        }
        return c;
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleMenuListener();
    }

    public AccessibleContext createAccessibleContext() {
        return new AccessibleMenu();
    }

    protected class AccessibleMenu
    extends AbstractButton.AccessibleAbstractButton
    implements AccessibleSelection {
        protected AccessibleMenu() {
            Menu.this.unoAccessibleSelection = (XAccessibleSelection)UnoRuntime.queryInterface(XAccessibleSelection.class, (Object)Menu.this.unoAccessibleContext);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }

        public int getAccessibleIndexInParent() {
            if (this.getAccessibleParent() instanceof Menu) {
                return ((Menu)this.getAccessibleParent()).indexOf(Menu.this);
            }
            return super.getAccessibleIndexInParent();
        }

        public synchronized int getAccessibleChildrenCount() {
            return Menu.this.children.size();
        }

        public synchronized Accessible getAccessibleChild(int i) {
            try {
                if (i < Menu.this.children.size()) {
                    return (Accessible)Menu.this.children.get(i);
                }
                return null;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleAt(java.awt.Point p) {
            try {
                Component c = AccessibleObjectFactory.getAccessibleComponent(Menu.this.unoAccessibleComponent.getAccessibleAtPoint(new Point(p.x, p.y)));
                return (Accessible)((Object)c);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public Accessible getAccessibleSelection(int i) {
            try {
                return (Accessible)((Object)Menu.this.getComponent(Menu.this.unoAccessibleSelection.getSelectedAccessibleChild(i)));
            }
            catch (Exception e) {
                return null;
            }
        }

        public void addAccessibleSelection(int i) {
            try {
                Accessible a = this.getAccessibleChild(i);
                if (a instanceof MenuItem) {
                    a.getAccessibleContext().getAccessibleAction().doAccessibleAction(0);
                } else {
                    Menu.this.unoAccessibleSelection.selectAccessibleChild(i);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void clearAccessibleSelection() {
            try {
                Menu.this.unoAccessibleSelection.clearAccessibleSelection();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }

        public int getAccessibleSelectionCount() {
            try {
                return Menu.this.unoAccessibleSelection.getSelectedAccessibleChildCount();
            }
            catch (RuntimeException e) {
                return 0;
            }
        }

        public boolean isAccessibleChildSelected(int i) {
            try {
                return Menu.this.unoAccessibleSelection.isAccessibleChildSelected(i);
            }
            catch (Exception e) {
                return false;
            }
        }

        public void removeAccessibleSelection(int i) {
            if (this.isAccessibleChildSelected(i)) {
                this.clearAccessibleSelection();
            }
        }

        public void selectAllAccessibleSelection() {
        }
    }

    protected class AccessibleMenuListener
    extends Component.AccessibleUNOComponentListener {
        protected AccessibleMenuListener() {
        }

        public void notifyEvent(AccessibleEventObject event) {
            switch (event.EventId) {
                case 7: {
                    if (AnyConverter.isObject((Object)event.OldValue)) {
                        Menu.this.remove(event.OldValue);
                    }
                    if (!AnyConverter.isObject((Object)event.NewValue)) break;
                    Menu.this.add(event.NewValue);
                    break;
                }
                case 9: {
                    break;
                }
                default: {
                    super.notifyEvent(event);
                }
            }
        }
    }
}

