/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.AccessibleRelation;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEditableText;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleRelationSet;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleText;
import org.openoffice.java.accessibility.AccessibleActionImpl;
import org.openoffice.java.accessibility.AccessibleEditableTextImpl;
import org.openoffice.java.accessibility.AccessibleHypertextImpl;
import org.openoffice.java.accessibility.Component;
import org.openoffice.java.accessibility.Container;

public class Paragraph
extends Container
implements Accessible {
    protected Paragraph(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        super(AccessibleRole.TEXT, xAccessible, xAccessibleContext);
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleParagraphListener();
    }

    public AccessibleContext createAccessibleContext() {
        return new AccessibleParagraph();
    }

    protected class AccessibleParagraph
    extends Container.AccessibleContainer {
        protected AccessibleParagraph() {
            super(false);
            Paragraph.this.accessibleText = AccessibleHypertextImpl.get((XInterface)Paragraph.this.unoAccessibleContext);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        public AccessibleEditableText getAccessibleEditableText() {
            if (Paragraph.this.disposed) {
                return null;
            }
            try {
                XAccessibleEditableText unoAccessibleText = (XAccessibleEditableText)UnoRuntime.queryInterface(XAccessibleEditableText.class, (Object)Paragraph.this.unoAccessibleComponent);
                if (unoAccessibleText != null) {
                    return new AccessibleEditableTextImpl(unoAccessibleText);
                }
                return null;
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public AccessibleAction getAccessibleAction() {
            try {
                XAccessibleAction unoAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, (Object)Paragraph.this.unoAccessibleComponent);
                return unoAccessibleAction != null ? new AccessibleActionImpl(unoAccessibleAction) : null;
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public AccessibleRelationSet getAccessibleRelationSet() {
            try {
                XAccessibleRelationSet unoAccessibleRelationSet = Paragraph.this.unoAccessible.getAccessibleContext().getAccessibleRelationSet();
                if (unoAccessibleRelationSet == null) {
                    return super.getAccessibleRelationSet();
                }
                AccessibleRelationSet relationSet = new AccessibleRelationSet();
                int count = unoAccessibleRelationSet.getRelationCount();
                block11: for (int i = 0; i < count; ++i) {
                    AccessibleRelation unoAccessibleRelation = unoAccessibleRelationSet.getRelation(i);
                    switch (unoAccessibleRelation.RelationType) {
                        case 3: {
                            relationSet.add(new javax.accessibility.AccessibleRelation(javax.accessibility.AccessibleRelation.CONTROLLED_BY, Paragraph.this.getAccessibleComponents(unoAccessibleRelation.TargetSet)));
                            continue block11;
                        }
                        case 4: {
                            relationSet.add(new javax.accessibility.AccessibleRelation(javax.accessibility.AccessibleRelation.CONTROLLER_FOR, Paragraph.this.getAccessibleComponents(unoAccessibleRelation.TargetSet)));
                            continue block11;
                        }
                        case 6: {
                            relationSet.add(new javax.accessibility.AccessibleRelation(javax.accessibility.AccessibleRelation.LABELED_BY, Paragraph.this.getAccessibleComponents(unoAccessibleRelation.TargetSet)));
                            continue block11;
                        }
                        case 7: {
                            relationSet.add(new javax.accessibility.AccessibleRelation(javax.accessibility.AccessibleRelation.MEMBER_OF, Paragraph.this.getAccessibleComponents(unoAccessibleRelation.TargetSet)));
                            continue block11;
                        }
                        case 2: {
                            relationSet.add(new javax.accessibility.AccessibleRelation("flowsTo", Paragraph.this.getAccessibleComponents(unoAccessibleRelation.TargetSet)));
                            continue block11;
                        }
                        case 1: {
                            relationSet.add(new javax.accessibility.AccessibleRelation("flowsFrom", Paragraph.this.getAccessibleComponents(unoAccessibleRelation.TargetSet)));
                            continue block11;
                        }
                    }
                }
                return relationSet;
            }
            catch (IndexOutOfBoundsException e) {
                return super.getAccessibleRelationSet();
            }
            catch (RuntimeException e) {
                return super.getAccessibleRelationSet();
            }
        }
    }

    protected class AccessibleParagraphListener
    extends Container.AccessibleContainerListener {
        protected AccessibleParagraphListener() {
        }

        protected void setComponentState(short state, boolean enable) {
            switch (state) {
                case 6: {
                    Paragraph.this.fireStatePropertyChange(AccessibleState.EDITABLE, enable);
                    break;
                }
                case 17: {
                    Paragraph.this.fireStatePropertyChange(AccessibleState.MULTI_LINE, enable);
                    break;
                }
                case 26: {
                    break;
                }
                default: {
                    super.setComponentState(state, enable);
                }
            }
        }

        protected void handleVisibleDataChanged() {
            AccessibleText at;
            AccessibleContext ac;
            if (Paragraph.this.isFocusOwner() && (ac = Paragraph.this.accessibleContext) != null && (at = ac.getAccessibleText()) != null) {
                int pos = at.getCaretPosition();
                Paragraph.this.firePropertyChange("AccessibleCaret", new Integer(-1), new Integer(pos));
            }
        }

        public void notifyEvent(AccessibleEventObject event) {
            switch (event.EventId) {
                case 20: {
                    Paragraph.this.firePropertyChange("AccessibleCaret", Component.toNumber(event.OldValue), Component.toNumber(event.NewValue));
                    break;
                }
                case 6: 
                case 10: {
                    this.handleVisibleDataChanged();
                }
                default: {
                    super.notifyEvent(event);
                }
            }
        }
    }
}

