/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.AccessibleRelation;
import com.sun.star.accessibility.IllegalAccessibleComponentStateException;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleImage;
import com.sun.star.accessibility.XAccessibleRelationSet;
import com.sun.star.accessibility.XAccessibleTable;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.accessibility.XAccessibleValue;
import com.sun.star.awt.Point;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.Locale;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedTable;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.JLabel;
import org.openoffice.java.accessibility.AccessibleActionImpl;
import org.openoffice.java.accessibility.AccessibleComponentImpl;
import org.openoffice.java.accessibility.AccessibleIconImpl;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.AccessibleRoleAdapter;
import org.openoffice.java.accessibility.AccessibleStateAdapter;
import org.openoffice.java.accessibility.AccessibleTextImpl;
import org.openoffice.java.accessibility.AccessibleValueImpl;
import org.openoffice.java.accessibility.DescendantManager;

public class Table
extends DescendantManager
implements Accessible {
    protected Table(XAccessible xAccessible, XAccessibleContext xAccessibleContext, boolean multiselectable) {
        super(xAccessible, xAccessibleContext, multiselectable);
    }

    protected void setActiveDescendant(Accessible descendant) {
        Accessible oldAD = this.activeDescendant;
        this.activeDescendant = descendant;
        this.firePropertyChange("AccessibleActiveDescendant", oldAD, descendant);
    }

    protected void setActiveDescendant(Object any) {
        TableCell descendant = null;
        try {
            XAccessible unoAccessible;
            if (AnyConverter.isObject((Object)any) && (unoAccessible = (XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)any)) != null) {
                descendant = new TableCell(unoAccessible);
            }
            this.setActiveDescendant(descendant);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void add(XAccessible unoAccessible) {
        if (unoAccessible != null) {
            TableCell cell = new TableCell(unoAccessible);
            this.firePropertyChange("AccessibleChild", null, cell.getAccessibleContext());
        }
    }

    protected void remove(XAccessible unoAccessible) {
        if (unoAccessible != null) {
            TableCell cell = new TableCell(unoAccessible);
            this.firePropertyChange("AccessibleChild", cell.getAccessibleContext(), null);
        }
    }

    protected void add(Object any) {
        try {
            this.add((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)any));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void remove(Object any) {
        try {
            this.remove((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)any));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleTableListener();
    }

    public AccessibleContext createAccessibleContext() {
        return new AccessibleTable();
    }

    class TableCell
    extends Component
    implements Accessible {
        protected XAccessible unoAccessible;
        AccessibleContext accessibleContext = null;

        public TableCell(XAccessible xAccessible) {
            this.unoAccessible = xAccessible;
        }

        public Object[] create(Object[] targetSet) {
            try {
                ArrayList<TableCell> list = new ArrayList<TableCell>(targetSet.length);
                for (int i = 0; i < targetSet.length; ++i) {
                    XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface(XAccessible.class, (Object)targetSet[i]);
                    if (xAccessible == null) continue;
                    list.add(new TableCell(xAccessible));
                }
                list.trimToSize();
                return list.toArray();
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                try {
                    XAccessibleContext xAccessibleContext = this.unoAccessible.getAccessibleContext();
                    if (xAccessibleContext != null) {
                        AccessibleTableCell ac = new AccessibleTableCell(xAccessibleContext);
                        ac.setAccessibleParent(Table.this);
                        this.accessibleContext = ac;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return this.accessibleContext;
        }

        protected class AccessibleTableCell
        extends AccessibleContext {
            XAccessibleContext unoAccessibleContext;

            public AccessibleTableCell(XAccessibleContext xAccessibleContext) {
                this.unoAccessibleContext = xAccessibleContext;
            }

            public String getAccessibleName() {
                try {
                    return this.unoAccessibleContext.getAccessibleName();
                }
                catch (RuntimeException e) {
                    return null;
                }
            }

            public void setAccessibleName(String name) {
            }

            public String getAccessibleDescription() {
                try {
                    return this.unoAccessibleContext.getAccessibleDescription();
                }
                catch (RuntimeException e) {
                    return null;
                }
            }

            public void setAccessibleDescription(String name) {
            }

            public AccessibleRole getAccessibleRole() {
                try {
                    AccessibleRole role = AccessibleRoleAdapter.getAccessibleRole(this.unoAccessibleContext.getAccessibleRole());
                    return role != null ? role : AccessibleRole.LABEL;
                }
                catch (RuntimeException e) {
                    return null;
                }
            }

            public java.util.Locale getLocale() throws IllegalComponentStateException {
                try {
                    Locale unoLocale = this.unoAccessibleContext.getLocale();
                    return new java.util.Locale(unoLocale.Language, unoLocale.Country);
                }
                catch (IllegalAccessibleComponentStateException e) {
                    throw new IllegalComponentStateException(e.getMessage());
                }
                catch (RuntimeException e) {
                    return Table.this.getLocale();
                }
            }

            public int getAccessibleIndexInParent() {
                try {
                    return this.unoAccessibleContext.getAccessibleIndexInParent();
                }
                catch (RuntimeException e) {
                    return -1;
                }
            }

            public int getAccessibleChildrenCount() {
                try {
                    return this.unoAccessibleContext.getAccessibleChildCount();
                }
                catch (RuntimeException e) {
                    return 0;
                }
            }

            public Accessible getAccessibleChild(int i) {
                Accessible child = null;
                try {
                    XAccessible xAccessible = this.unoAccessibleContext.getAccessibleChild(i);
                    Accessible activeDescendant = Table.this.activeDescendant;
                    if (activeDescendant instanceof TableCell && ((TableCell)activeDescendant).unoAccessible.equals(xAccessible)) {
                        child = activeDescendant;
                    } else if (xAccessible != null) {
                        child = new TableCell(xAccessible);
                    }
                }
                catch (IndexOutOfBoundsException e) {
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return child;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                try {
                    return AccessibleStateAdapter.getAccessibleStateSet(TableCell.this, this.unoAccessibleContext.getAccessibleStateSet());
                }
                catch (RuntimeException e) {
                    return AccessibleStateAdapter.getDefunctStateSet();
                }
            }

            public AccessibleRelationSet getAccessibleRelationSet() {
                try {
                    XAccessibleRelationSet unoAccessibleRelationSet = this.unoAccessibleContext.getAccessibleRelationSet();
                    if (unoAccessibleRelationSet == null) {
                        return null;
                    }
                    AccessibleRelationSet relationSet = new AccessibleRelationSet();
                    int count = unoAccessibleRelationSet.getRelationCount();
                    block10: for (int i = 0; i < count; ++i) {
                        AccessibleRelation unoAccessibleRelation = unoAccessibleRelationSet.getRelation(i);
                        switch (unoAccessibleRelation.RelationType) {
                            case 3: {
                                relationSet.add(new javax.accessibility.AccessibleRelation(javax.accessibility.AccessibleRelation.CONTROLLED_BY, TableCell.this.create(unoAccessibleRelation.TargetSet)));
                                continue block10;
                            }
                            case 4: {
                                relationSet.add(new javax.accessibility.AccessibleRelation(javax.accessibility.AccessibleRelation.CONTROLLER_FOR, TableCell.this.create(unoAccessibleRelation.TargetSet)));
                                continue block10;
                            }
                            case 6: {
                                relationSet.add(new javax.accessibility.AccessibleRelation(javax.accessibility.AccessibleRelation.LABELED_BY, TableCell.this.create(unoAccessibleRelation.TargetSet)));
                                continue block10;
                            }
                            case 5: {
                                relationSet.add(new javax.accessibility.AccessibleRelation(javax.accessibility.AccessibleRelation.LABEL_FOR, TableCell.this.create(unoAccessibleRelation.TargetSet)));
                                continue block10;
                            }
                            case 7: {
                                relationSet.add(new javax.accessibility.AccessibleRelation(javax.accessibility.AccessibleRelation.MEMBER_OF, TableCell.this.create(unoAccessibleRelation.TargetSet)));
                                continue block10;
                            }
                        }
                    }
                    return relationSet;
                }
                catch (IndexOutOfBoundsException e) {
                    return null;
                }
                catch (RuntimeException e) {
                    return null;
                }
            }

            public AccessibleComponent getAccessibleComponent() {
                try {
                    XAccessibleComponent unoAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)this.unoAccessibleContext);
                    return unoAccessibleComponent != null ? new AccessibleComponentImpl(unoAccessibleComponent) : null;
                }
                catch (RuntimeException e) {
                    return null;
                }
            }

            public AccessibleAction getAccessibleAction() {
                try {
                    XAccessibleAction unoAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, (Object)this.unoAccessibleContext);
                    return unoAccessibleAction != null ? new AccessibleActionImpl(unoAccessibleAction) : null;
                }
                catch (RuntimeException e) {
                    return null;
                }
            }

            public AccessibleText getAccessibleText() {
                if (Table.this.disposed) {
                    return null;
                }
                try {
                    XAccessibleText unoAccessibleText = (XAccessibleText)UnoRuntime.queryInterface(XAccessibleText.class, (Object)this.unoAccessibleContext);
                    return unoAccessibleText != null ? new AccessibleTextImpl(unoAccessibleText) : null;
                }
                catch (RuntimeException e) {
                    return null;
                }
            }

            public AccessibleValue getAccessibleValue() {
                try {
                    XAccessibleValue unoAccessibleValue = (XAccessibleValue)UnoRuntime.queryInterface(XAccessibleValue.class, (Object)this.unoAccessibleContext);
                    return unoAccessibleValue != null ? new AccessibleValueImpl(unoAccessibleValue) : null;
                }
                catch (RuntimeException e) {
                    return null;
                }
            }

            public AccessibleIcon[] getAccessibleIcon() {
                try {
                    XAccessibleImage unoAccessibleImage = (XAccessibleImage)UnoRuntime.queryInterface(XAccessibleImage.class, (Object)this.unoAccessibleContext);
                    if (unoAccessibleImage != null) {
                        AccessibleIcon[] icons = new AccessibleIcon[]{new AccessibleIconImpl(unoAccessibleImage)};
                        return icons;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return null;
            }
        }
    }

    protected class AccessibleTable
    extends DescendantManager.AccessibleDescendantManager
    implements AccessibleExtendedTable {
        protected XAccessibleTable unoAccessibleTable;

        public AccessibleTable() {
            this.unoAccessibleTable = (XAccessibleTable)UnoRuntime.queryInterface(XAccessibleTable.class, (Object)Table.this.unoAccessibleContext);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TABLE;
        }

        public javax.accessibility.AccessibleTable getAccessibleTable() {
            return this;
        }

        public Accessible getAccessibleChild(int i) {
            Accessible child = null;
            try {
                XAccessible xAccessible = Table.this.unoAccessibleContext.getAccessibleChild(i);
                if (xAccessible != null) {
                    Accessible activeDescendant = Table.this.activeDescendant;
                    child = activeDescendant instanceof TableCell && xAccessible.equals(((TableCell)activeDescendant).unoAccessible) ? activeDescendant : new TableCell(xAccessible);
                }
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return child;
        }

        public Accessible getAccessibleAt(java.awt.Point p) {
            Accessible child = null;
            try {
                XAccessible xAccessible = Table.this.unoAccessibleComponent.getAccessibleAtPoint(new Point(p.x, p.y));
                if (xAccessible != null) {
                    Accessible activeDescendant = Table.this.activeDescendant;
                    child = activeDescendant instanceof TableCell && xAccessible.equals(((TableCell)activeDescendant).unoAccessible) ? activeDescendant : new TableCell(xAccessible);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return child;
        }

        public Accessible getAccessibleSelection(int i) {
            Accessible child = null;
            try {
                XAccessible xAccessible = Table.this.unoAccessibleSelection.getSelectedAccessibleChild(i);
                if (xAccessible != null) {
                    Accessible activeDescendant = Table.this.activeDescendant;
                    child = activeDescendant instanceof TableCell && xAccessible.equals(((TableCell)activeDescendant).unoAccessible) ? activeDescendant : new TableCell(xAccessible);
                }
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return child;
        }

        public Accessible getAccessibleAt(int r, int c) {
            Accessible child = null;
            try {
                XAccessible xAccessible = this.unoAccessibleTable.getAccessibleCellAt(r, c);
                if (xAccessible != null) {
                    Accessible activeDescendant = Table.this.activeDescendant;
                    child = activeDescendant instanceof TableCell && xAccessible.equals(((TableCell)activeDescendant).unoAccessible) ? activeDescendant : new TableCell(xAccessible);
                }
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            return child;
        }

        public Accessible getAccessibleCaption() {
            return null;
        }

        public int getAccessibleColumnCount() {
            try {
                return this.unoAccessibleTable.getAccessibleColumnCount();
            }
            catch (RuntimeException e) {
                return 0;
            }
        }

        public Accessible getAccessibleColumnDescription(int c) {
            try {
                return new JLabel(this.unoAccessibleTable.getAccessibleColumnDescription(c));
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public int getAccessibleColumnExtentAt(int r, int c) {
            try {
                return this.unoAccessibleTable.getAccessibleColumnExtentAt(r, c);
            }
            catch (IndexOutOfBoundsException e) {
                return 0;
            }
            catch (RuntimeException e) {
                return 0;
            }
        }

        public javax.accessibility.AccessibleTable getAccessibleColumnHeader() {
            return null;
        }

        public int getAccessibleRowCount() {
            try {
                return this.unoAccessibleTable.getAccessibleRowCount();
            }
            catch (RuntimeException e) {
                return 0;
            }
        }

        public Accessible getAccessibleRowDescription(int r) {
            try {
                return new JLabel(this.unoAccessibleTable.getAccessibleRowDescription(r));
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public int getAccessibleRowExtentAt(int r, int c) {
            try {
                return this.unoAccessibleTable.getAccessibleRowExtentAt(r, c);
            }
            catch (IndexOutOfBoundsException e) {
                return 0;
            }
            catch (RuntimeException e) {
                return 0;
            }
        }

        public javax.accessibility.AccessibleTable getAccessibleRowHeader() {
            return null;
        }

        public Accessible getAccessibleSummary() {
            return null;
        }

        public int[] getSelectedAccessibleColumns() {
            try {
                return this.unoAccessibleTable.getSelectedAccessibleColumns();
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public int[] getSelectedAccessibleRows() {
            try {
                return this.unoAccessibleTable.getSelectedAccessibleRows();
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public boolean isAccessibleColumnSelected(int c) {
            try {
                return this.unoAccessibleTable.isAccessibleColumnSelected(c);
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
            catch (RuntimeException e) {
                return false;
            }
        }

        public boolean isAccessibleRowSelected(int r) {
            try {
                return this.unoAccessibleTable.isAccessibleRowSelected(r);
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
            catch (RuntimeException e) {
                return false;
            }
        }

        public boolean isAccessibleSelected(int r, int c) {
            try {
                return this.unoAccessibleTable.isAccessibleSelected(r, c);
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
            catch (RuntimeException e) {
                return false;
            }
        }

        public void setAccessibleCaption(Accessible accessible) {
        }

        public void setAccessibleColumnDescription(int param, Accessible accessible) {
        }

        public void setAccessibleColumnHeader(javax.accessibility.AccessibleTable accessibleTable) {
        }

        public void setAccessibleRowDescription(int param, Accessible accessible) {
        }

        public void setAccessibleRowHeader(javax.accessibility.AccessibleTable accessibleTable) {
        }

        public void setAccessibleSummary(Accessible accessible) {
        }

        public int getAccessibleColumn(int index) {
            try {
                return this.unoAccessibleTable.getAccessibleColumn(index);
            }
            catch (IndexOutOfBoundsException e) {
                return -1;
            }
            catch (RuntimeException e) {
                return -1;
            }
        }

        public int getAccessibleIndex(int r, int c) {
            try {
                return this.unoAccessibleTable.getAccessibleIndex(r, c);
            }
            catch (IndexOutOfBoundsException e) {
                return -1;
            }
            catch (RuntimeException e) {
                return -1;
            }
        }

        public int getAccessibleRow(int index) {
            try {
                return this.unoAccessibleTable.getAccessibleRow(index);
            }
            catch (IndexOutOfBoundsException e) {
                return -1;
            }
            catch (RuntimeException e) {
                return -1;
            }
        }
    }

    protected class AccessibleTableListener
    extends DescendantManager.AccessibleDescendantManagerListener {
        protected AccessibleTableListener() {
        }

        public void notifyEvent(AccessibleEventObject event) {
            switch (event.EventId) {
                case 5: {
                    Table.this.setActiveDescendant(event.NewValue);
                    break;
                }
                case 7: {
                    if (AnyConverter.isObject((Object)event.OldValue)) {
                        Table.this.remove(event.OldValue);
                    }
                    if (!AnyConverter.isObject((Object)event.NewValue)) break;
                    Table.this.add(event.NewValue);
                    break;
                }
                default: {
                    super.notifyEvent(event);
                }
            }
        }
    }
}

