/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleRelation;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEditableText;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleRelationSet;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleText;
import org.openoffice.java.accessibility.AccessibleActionImpl;
import org.openoffice.java.accessibility.AccessibleEditableTextImpl;
import org.openoffice.java.accessibility.AccessibleTextImpl;
import org.openoffice.java.accessibility.Component;

public class TextComponent
extends Component
implements Accessible {
    protected TextComponent(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        super(xAccessible, xAccessibleContext);
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleTextComponentListener();
    }

    public AccessibleContext createAccessibleContext() {
        return new AccessibleTextComponent();
    }

    protected class AccessibleTextComponent
    extends Component.AccessibleUNOComponent {
        protected AccessibleTextComponent() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TEXT;
        }

        public AccessibleText getAccessibleText() {
            if (TextComponent.this.disposed) {
                return null;
            }
            try {
                XAccessibleText unoAccessibleText = (XAccessibleText)UnoRuntime.queryInterface(XAccessibleText.class, (Object)TextComponent.this.unoAccessibleComponent);
                if (unoAccessibleText != null) {
                    return new AccessibleTextImpl(unoAccessibleText);
                }
                return null;
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public AccessibleEditableText getAccessibleEditableText() {
            try {
                XAccessibleEditableText unoAccessibleText = (XAccessibleEditableText)UnoRuntime.queryInterface(XAccessibleEditableText.class, (Object)TextComponent.this.unoAccessibleComponent);
                if (unoAccessibleText != null) {
                    return new AccessibleEditableTextImpl(unoAccessibleText);
                }
                return null;
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public AccessibleAction getAccessibleAction() {
            try {
                XAccessibleAction unoAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, (Object)TextComponent.this.unoAccessibleComponent);
                return unoAccessibleAction != null ? new AccessibleActionImpl(unoAccessibleAction) : null;
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public AccessibleRelationSet getAccessibleRelationSet() {
            try {
                XAccessibleRelationSet unoAccessibleRelationSet = TextComponent.this.unoAccessible.getAccessibleContext().getAccessibleRelationSet();
                if (unoAccessibleRelationSet == null) {
                    return super.getAccessibleRelationSet();
                }
                AccessibleRelationSet relationSet = new AccessibleRelationSet();
                int count = unoAccessibleRelationSet.getRelationCount();
                block11: for (int i = 0; i < count; ++i) {
                    AccessibleRelation unoAccessibleRelation = unoAccessibleRelationSet.getRelation(i);
                    switch (unoAccessibleRelation.RelationType) {
                        case 3: {
                            relationSet.add(new javax.accessibility.AccessibleRelation(javax.accessibility.AccessibleRelation.CONTROLLED_BY, TextComponent.this.getAccessibleComponents(unoAccessibleRelation.TargetSet)));
                            continue block11;
                        }
                        case 4: {
                            relationSet.add(new javax.accessibility.AccessibleRelation(javax.accessibility.AccessibleRelation.CONTROLLER_FOR, TextComponent.this.getAccessibleComponents(unoAccessibleRelation.TargetSet)));
                            continue block11;
                        }
                        case 6: {
                            relationSet.add(new javax.accessibility.AccessibleRelation(javax.accessibility.AccessibleRelation.LABELED_BY, TextComponent.this.getAccessibleComponents(unoAccessibleRelation.TargetSet)));
                            continue block11;
                        }
                        case 7: {
                            relationSet.add(new javax.accessibility.AccessibleRelation(javax.accessibility.AccessibleRelation.MEMBER_OF, TextComponent.this.getAccessibleComponents(unoAccessibleRelation.TargetSet)));
                            continue block11;
                        }
                        case 2: {
                            relationSet.add(new javax.accessibility.AccessibleRelation("flowsTo", TextComponent.this.getAccessibleComponents(unoAccessibleRelation.TargetSet)));
                            continue block11;
                        }
                        case 1: {
                            relationSet.add(new javax.accessibility.AccessibleRelation("flowsFrom", TextComponent.this.getAccessibleComponents(unoAccessibleRelation.TargetSet)));
                            continue block11;
                        }
                    }
                }
                return relationSet;
            }
            catch (IndexOutOfBoundsException e) {
                return super.getAccessibleRelationSet();
            }
            catch (RuntimeException e) {
                return super.getAccessibleRelationSet();
            }
        }
    }

    protected class AccessibleTextComponentListener
    extends Component.AccessibleUNOComponentListener {
        protected AccessibleTextComponentListener() {
        }

        protected void setComponentState(short state, boolean enable) {
            switch (state) {
                case 6: {
                    TextComponent.this.fireStatePropertyChange(AccessibleState.EDITABLE, enable);
                    break;
                }
                case 17: {
                    TextComponent.this.fireStatePropertyChange(AccessibleState.MULTI_LINE, enable);
                    break;
                }
                case 26: {
                    break;
                }
                default: {
                    super.setComponentState(state, enable);
                }
            }
        }
    }
}

