/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.IllegalAccessibleComponentStateException;
import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.accessibility.XAccessibleImage;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.accessibility.XAccessibleTable;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.accessibility.XAccessibleValue;
import com.sun.star.awt.Point;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.Locale;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import java.awt.Component;
import java.awt.IllegalComponentStateException;
import java.util.ArrayList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedTable;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.JLabel;
import org.openoffice.java.accessibility.AccessibleActionImpl;
import org.openoffice.java.accessibility.AccessibleComponentImpl;
import org.openoffice.java.accessibility.AccessibleIconImpl;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.AccessibleRoleAdapter;
import org.openoffice.java.accessibility.AccessibleStateAdapter;
import org.openoffice.java.accessibility.AccessibleTextImpl;
import org.openoffice.java.accessibility.AccessibleValueImpl;
import org.openoffice.java.accessibility.DescendantManager;

public class Tree
extends DescendantManager
implements Accessible {
    protected Tree(XAccessible xAccessible, XAccessibleContext xAccessibleContext) {
        super(xAccessible, xAccessibleContext);
    }

    protected void setActiveDescendant(Accessible descendant) {
        Accessible oldAD = this.activeDescendant;
        this.activeDescendant = descendant;
        this.firePropertyChange("AccessibleActiveDescendant", oldAD, descendant);
    }

    protected void setActiveDescendant(Object any) {
        TreeItem descendant = null;
        try {
            XAccessible unoAccessible;
            if (AnyConverter.isObject((Object)any) && (unoAccessible = (XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)any)) != null) {
                descendant = new TreeItem(unoAccessible);
            }
            this.setActiveDescendant(descendant);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void add(XAccessible unoAccessible) {
        if (unoAccessible != null) {
            this.firePropertyChange("AccessibleChild", null, new TreeItem(unoAccessible));
        }
    }

    protected void remove(XAccessible unoAccessible) {
        if (unoAccessible != null) {
            this.firePropertyChange("AccessibleChild", new TreeItem(unoAccessible), null);
        }
    }

    protected void add(Object any) {
        try {
            this.add((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)any));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected void remove(Object any) {
        try {
            this.remove((XAccessible)AnyConverter.toObject((Type)AccessibleObjectFactory.XAccessibleType, (Object)any));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    protected XAccessibleEventListener createEventListener() {
        return new AccessibleTreeListener();
    }

    public AccessibleContext createAccessibleContext() {
        return new AccessibleTree();
    }

    class TreeItem
    extends Component
    implements Accessible {
        protected XAccessible unoAccessible;
        AccessibleContext accessibleContext = null;

        public TreeItem(XAccessible xAccessible) {
            this.unoAccessible = xAccessible;
        }

        public Object[] create(Object[] targetSet) {
            try {
                ArrayList<TreeItem> list = new ArrayList<TreeItem>(targetSet.length);
                for (int i = 0; i < targetSet.length; ++i) {
                    XAccessible xAccessible = (XAccessible)UnoRuntime.queryInterface(XAccessible.class, (Object)targetSet[i]);
                    if (xAccessible == null) continue;
                    list.add(new TreeItem(xAccessible));
                }
                list.trimToSize();
                return list.toArray();
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                try {
                    XAccessibleContext xAccessibleContext = this.unoAccessible.getAccessibleContext();
                    if (xAccessibleContext != null) {
                        AccessibleTreeItem ac = new AccessibleTreeItem(xAccessibleContext);
                        ac.setAccessibleParent(Tree.this);
                        this.accessibleContext = ac;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            return this.accessibleContext;
        }

        protected class AccessibleTreeItem
        extends AccessibleContext
        implements AccessibleSelection {
            XAccessibleContext unoAccessibleContext;
            XAccessibleSelection unoAccessibleSelection;

            public AccessibleTreeItem(XAccessibleContext xAccessibleContext) {
                this.unoAccessibleContext = xAccessibleContext;
                this.unoAccessibleSelection = (XAccessibleSelection)UnoRuntime.queryInterface(XAccessibleSelection.class, (Object)xAccessibleContext);
            }

            public String getAccessibleName() {
                try {
                    return this.unoAccessibleContext.getAccessibleName();
                }
                catch (RuntimeException e) {
                    return null;
                }
            }

            public void setAccessibleName(String name) {
            }

            public String getAccessibleDescription() {
                try {
                    return this.unoAccessibleContext.getAccessibleDescription();
                }
                catch (RuntimeException e) {
                    return null;
                }
            }

            public void setAccessibleDescription(String name) {
            }

            public AccessibleRole getAccessibleRole() {
                try {
                    AccessibleRole role = AccessibleRoleAdapter.getAccessibleRole(this.unoAccessibleContext.getAccessibleRole());
                    return role != null ? role : AccessibleRole.LABEL;
                }
                catch (RuntimeException e) {
                    return null;
                }
            }

            public java.util.Locale getLocale() throws IllegalComponentStateException {
                try {
                    Locale unoLocale = this.unoAccessibleContext.getLocale();
                    return new java.util.Locale(unoLocale.Language, unoLocale.Country);
                }
                catch (IllegalAccessibleComponentStateException e) {
                    throw new IllegalComponentStateException(e.getMessage());
                }
                catch (RuntimeException e) {
                    return Tree.this.getLocale();
                }
            }

            public int getAccessibleIndexInParent() {
                try {
                    return this.unoAccessibleContext.getAccessibleIndexInParent();
                }
                catch (RuntimeException e) {
                    return -1;
                }
            }

            public int getAccessibleChildrenCount() {
                try {
                    return this.unoAccessibleContext.getAccessibleChildCount();
                }
                catch (RuntimeException e) {
                    return 0;
                }
            }

            public Accessible getAccessibleChild(int i) {
                Accessible child = null;
                try {
                    XAccessible xAccessible = this.unoAccessibleContext.getAccessibleChild(i);
                    Accessible activeDescendant = Tree.this.activeDescendant;
                    if (activeDescendant instanceof TreeItem && ((TreeItem)activeDescendant).unoAccessible.equals(xAccessible)) {
                        child = activeDescendant;
                    } else if (xAccessible != null) {
                        child = new TreeItem(xAccessible);
                    }
                }
                catch (IndexOutOfBoundsException e) {
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return child;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                try {
                    return AccessibleStateAdapter.getAccessibleStateSet(TreeItem.this, this.unoAccessibleContext.getAccessibleStateSet());
                }
                catch (RuntimeException e) {
                    return AccessibleStateAdapter.getDefunctStateSet();
                }
            }

            public AccessibleComponent getAccessibleComponent() {
                try {
                    XAccessibleComponent unoAccessibleComponent = (XAccessibleComponent)UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)this.unoAccessibleContext);
                    return unoAccessibleComponent != null ? new AccessibleComponentImpl(unoAccessibleComponent) : null;
                }
                catch (RuntimeException e) {
                    return null;
                }
            }

            public AccessibleSelection getAccessibleSelection() {
                return this.unoAccessibleSelection != null ? this : null;
            }

            public AccessibleAction getAccessibleAction() {
                try {
                    XAccessibleAction unoAccessibleAction = (XAccessibleAction)UnoRuntime.queryInterface(XAccessibleAction.class, (Object)this.unoAccessibleContext);
                    return unoAccessibleAction != null ? new AccessibleActionImpl(unoAccessibleAction) : null;
                }
                catch (RuntimeException e) {
                    return null;
                }
            }

            public AccessibleText getAccessibleText() {
                if (Tree.this.disposed) {
                    return null;
                }
                try {
                    XAccessibleText unoAccessibleText = (XAccessibleText)UnoRuntime.queryInterface(XAccessibleText.class, (Object)this.unoAccessibleContext);
                    return unoAccessibleText != null ? new AccessibleTextImpl(unoAccessibleText) : null;
                }
                catch (RuntimeException e) {
                    return null;
                }
            }

            public AccessibleValue getAccessibleValue() {
                try {
                    XAccessibleValue unoAccessibleValue = (XAccessibleValue)UnoRuntime.queryInterface(XAccessibleValue.class, (Object)this.unoAccessibleContext);
                    return unoAccessibleValue != null ? new AccessibleValueImpl(unoAccessibleValue) : null;
                }
                catch (RuntimeException e) {
                    return null;
                }
            }

            public AccessibleIcon[] getAccessibleIcon() {
                try {
                    XAccessibleImage unoAccessibleImage = (XAccessibleImage)UnoRuntime.queryInterface(XAccessibleImage.class, (Object)this.unoAccessibleContext);
                    if (unoAccessibleImage != null) {
                        AccessibleIcon[] icons = new AccessibleIcon[]{new AccessibleIconImpl(unoAccessibleImage)};
                        return icons;
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return null;
            }

            public Accessible getAccessibleSelection(int i) {
                TreeItem child = null;
                try {
                    XAccessible xAccessible = this.unoAccessibleContext.getAccessibleChild(i);
                    if (xAccessible != null) {
                        child = new TreeItem(xAccessible);
                    }
                }
                catch (IndexOutOfBoundsException e) {
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                return child;
            }

            public void addAccessibleSelection(int i) {
                try {
                    this.unoAccessibleSelection.selectAccessibleChild(i);
                }
                catch (IndexOutOfBoundsException e) {
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }

            public void clearAccessibleSelection() {
                try {
                    this.unoAccessibleSelection.clearAccessibleSelection();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }

            public int getAccessibleSelectionCount() {
                try {
                    return this.unoAccessibleSelection.getSelectedAccessibleChildCount();
                }
                catch (RuntimeException e) {
                    return 0;
                }
            }

            public boolean isAccessibleChildSelected(int i) {
                try {
                    return this.unoAccessibleSelection.isAccessibleChildSelected(i);
                }
                catch (IndexOutOfBoundsException e) {
                    return false;
                }
                catch (RuntimeException e) {
                    return false;
                }
            }

            public void removeAccessibleSelection(int i) {
                try {
                    this.unoAccessibleSelection.deselectAccessibleChild(i);
                }
                catch (IndexOutOfBoundsException e) {
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }

            public void selectAllAccessibleSelection() {
                try {
                    this.unoAccessibleSelection.selectAllAccessibleChildren();
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
    }

    protected class AccessibleTree
    extends DescendantManager.AccessibleDescendantManager
    implements AccessibleExtendedTable {
        protected XAccessibleTable unoAccessibleTable;

        public AccessibleTree() {
            this.unoAccessibleTable = (XAccessibleTable)UnoRuntime.queryInterface(XAccessibleTable.class, (Object)Tree.this.unoAccessibleContext);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TREE;
        }

        public AccessibleTable getAccessibleTable() {
            return this.unoAccessibleTable != null ? this : null;
        }

        public Accessible getAccessibleChild(int i) {
            Accessible child = null;
            try {
                XAccessible xAccessible = Tree.this.unoAccessibleContext.getAccessibleChild(i);
                if (xAccessible != null) {
                    Accessible activeDescendant = Tree.this.activeDescendant;
                    child = activeDescendant instanceof TreeItem && xAccessible.equals(((TreeItem)activeDescendant).unoAccessible) ? activeDescendant : new TreeItem(xAccessible);
                }
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return child;
        }

        public Accessible getAccessibleAt(java.awt.Point p) {
            Accessible child = null;
            try {
                XAccessible xAccessible = Tree.this.unoAccessibleComponent.getAccessibleAtPoint(new Point(p.x, p.y));
                if (xAccessible != null) {
                    Accessible activeDescendant = Tree.this.activeDescendant;
                    child = activeDescendant instanceof TreeItem && xAccessible.equals(((TreeItem)activeDescendant).unoAccessible) ? activeDescendant : new TreeItem(xAccessible);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return child;
        }

        public Accessible getAccessibleSelection(int i) {
            Accessible child = null;
            try {
                XAccessible xAccessible = Tree.this.unoAccessibleContext.getAccessibleChild(i);
                if (xAccessible != null) {
                    Accessible activeDescendant = Tree.this.activeDescendant;
                    child = activeDescendant instanceof TreeItem && xAccessible.equals(((TreeItem)activeDescendant).unoAccessible) ? activeDescendant : new TreeItem(xAccessible);
                }
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return child;
        }

        public Accessible getAccessibleAt(int r, int c) {
            Accessible child = null;
            try {
                XAccessible xAccessible = this.unoAccessibleTable.getAccessibleCellAt(r, c);
                if (xAccessible != null) {
                    Accessible activeDescendant = Tree.this.activeDescendant;
                    child = activeDescendant instanceof TreeItem && xAccessible.equals(((TreeItem)activeDescendant).unoAccessible) ? activeDescendant : new TreeItem(xAccessible);
                }
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (RuntimeException e) {
                // empty catch block
            }
            return child;
        }

        public Accessible getAccessibleCaption() {
            return null;
        }

        public int getAccessibleColumnCount() {
            try {
                return this.unoAccessibleTable.getAccessibleColumnCount();
            }
            catch (RuntimeException e) {
                return 0;
            }
        }

        public Accessible getAccessibleColumnDescription(int c) {
            try {
                return new JLabel(this.unoAccessibleTable.getAccessibleColumnDescription(c));
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public int getAccessibleColumnExtentAt(int r, int c) {
            try {
                return this.unoAccessibleTable.getAccessibleColumnExtentAt(r, c);
            }
            catch (IndexOutOfBoundsException e) {
                return 0;
            }
            catch (RuntimeException e) {
                return 0;
            }
        }

        public AccessibleTable getAccessibleColumnHeader() {
            return null;
        }

        public int getAccessibleRowCount() {
            try {
                return this.unoAccessibleTable.getAccessibleRowCount();
            }
            catch (RuntimeException e) {
                return 0;
            }
        }

        public Accessible getAccessibleRowDescription(int r) {
            try {
                return new JLabel(this.unoAccessibleTable.getAccessibleRowDescription(r));
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public int getAccessibleRowExtentAt(int r, int c) {
            try {
                return this.unoAccessibleTable.getAccessibleRowExtentAt(r, c);
            }
            catch (IndexOutOfBoundsException e) {
                return 0;
            }
            catch (RuntimeException e) {
                return 0;
            }
        }

        public AccessibleTable getAccessibleRowHeader() {
            return null;
        }

        public Accessible getAccessibleSummary() {
            return null;
        }

        public int[] getSelectedAccessibleColumns() {
            try {
                return this.unoAccessibleTable.getSelectedAccessibleColumns();
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public int[] getSelectedAccessibleRows() {
            try {
                return this.unoAccessibleTable.getSelectedAccessibleRows();
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public boolean isAccessibleColumnSelected(int c) {
            try {
                return this.unoAccessibleTable.isAccessibleColumnSelected(c);
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
            catch (RuntimeException e) {
                return false;
            }
        }

        public boolean isAccessibleRowSelected(int r) {
            try {
                return this.unoAccessibleTable.isAccessibleRowSelected(r);
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
            catch (RuntimeException e) {
                return false;
            }
        }

        public boolean isAccessibleSelected(int r, int c) {
            try {
                return this.unoAccessibleTable.isAccessibleSelected(r, c);
            }
            catch (IndexOutOfBoundsException e) {
                return false;
            }
            catch (RuntimeException e) {
                return false;
            }
        }

        public void setAccessibleCaption(Accessible accessible) {
        }

        public void setAccessibleColumnDescription(int param, Accessible accessible) {
        }

        public void setAccessibleColumnHeader(AccessibleTable accessibleTable) {
        }

        public void setAccessibleRowDescription(int param, Accessible accessible) {
        }

        public void setAccessibleRowHeader(AccessibleTable accessibleTable) {
        }

        public void setAccessibleSummary(Accessible accessible) {
        }

        public int getAccessibleColumn(int index) {
            try {
                return this.unoAccessibleTable.getAccessibleColumn(index);
            }
            catch (IndexOutOfBoundsException e) {
                return -1;
            }
            catch (RuntimeException e) {
                return -1;
            }
        }

        public int getAccessibleIndex(int r, int c) {
            try {
                return this.unoAccessibleTable.getAccessibleIndex(r, c);
            }
            catch (IndexOutOfBoundsException e) {
                return -1;
            }
            catch (RuntimeException e) {
                return -1;
            }
        }

        public int getAccessibleRow(int index) {
            try {
                return this.unoAccessibleTable.getAccessibleRow(index);
            }
            catch (IndexOutOfBoundsException e) {
                return -1;
            }
            catch (RuntimeException e) {
                return -1;
            }
        }
    }

    protected class AccessibleTreeListener
    extends DescendantManager.AccessibleDescendantManagerListener {
        protected AccessibleTreeListener() {
        }

        public void notifyEvent(AccessibleEventObject event) {
            switch (event.EventId) {
                case 5: {
                    Tree.this.setActiveDescendant(event.NewValue);
                    break;
                }
                case 7: {
                    if (AnyConverter.isObject((Object)event.OldValue)) {
                        Tree.this.remove(event.OldValue);
                    }
                    if (!AnyConverter.isObject((Object)event.NewValue)) break;
                    Tree.this.add(event.NewValue);
                    break;
                }
                case 32: {
                    Tree.this.firePropertyChange("AccessibleState", AccessibleState.COLLAPSED, AccessibleState.EXPANDED);
                    break;
                }
                case 33: {
                    Tree.this.firePropertyChange("AccessibleState", AccessibleState.EXPANDED, AccessibleState.COLLAPSED);
                    break;
                }
                default: {
                    super.notifyEvent(event);
                }
            }
        }
    }
}

