/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleEventBroadcaster;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.awt.Size;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import org.openoffice.java.accessibility.AccessibleObjectFactory;
import org.openoffice.java.accessibility.Dialog;
import org.openoffice.java.accessibility.Frame;
import org.openoffice.java.accessibility.NativeFrame;

public class Window
extends java.awt.Window
implements Accessible,
NativeFrame {
    protected XAccessibleComponent unoAccessibleComponent;
    boolean opened = false;
    boolean visible = false;
    EventQueue eventQueue = null;
    Component initialComponent = null;
    protected AccessibleContext accessibleContext = null;

    public Window(java.awt.Window owner, XAccessibleComponent xAccessibleComponent) {
        super(owner);
        this.initialize(xAccessibleComponent);
    }

    private void initialize(XAccessibleComponent xAccessibleComponent) {
        this.unoAccessibleComponent = xAccessibleComponent;
        this.eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        XAccessibleEventBroadcaster broadcaster = (XAccessibleEventBroadcaster)UnoRuntime.queryInterface(XAccessibleEventBroadcaster.class, (Object)this.unoAccessibleComponent);
        if (broadcaster != null) {
            broadcaster.addAccessibleEventListener((XAccessibleEventListener)new AccessibleWindowListener());
        }
    }

    public Component getInitialComponent() {
        System.err.println("returning initial component object of class: " + this.initialComponent.getClass().getName());
        return this.initialComponent;
    }

    public void setInitialComponent(Component c) {
        this.initialComponent = c;
    }

    public Integer getHWND() {
        return null;
    }

    public boolean isShowing() {
        if (this.isVisible()) {
            Container parent = this.getParent();
            return parent == null || parent.isShowing();
        }
        return false;
    }

    public void addNotify() {
    }

    public void removeNotify() {
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean b) {
        if (this.visible != b) {
            this.visible = b;
            if (b) {
                if (!this.opened) {
                    this.postWindowEvent(200);
                    this.opened = true;
                }
                this.postComponentEvent(102);
            } else {
                this.postComponentEvent(103);
            }
        }
    }

    public void dispose() {
        this.setVisible(false);
        this.postWindowEvent(202);
        if (this.getOwner() instanceof Frame && ((Frame)this.getOwner()).active || this.getOwner() instanceof Dialog && ((Dialog)this.getOwner()).active) {
            this.eventQueue.postEvent(new WindowEvent(this.getOwner(), 207));
        }
    }

    protected void postWindowEvent(int i) {
        this.eventQueue.postEvent(new WindowEvent(this, i));
    }

    protected void postComponentEvent(int i) {
        this.eventQueue.postEvent(new ComponentEvent(this, i));
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleWindow();
        }
        return this.accessibleContext;
    }

    public boolean isDisplayable() {
        return true;
    }

    protected class AccessibleWindow
    extends Window.AccessibleAWTWindow {
        protected ComponentListener accessibleComponentHandler;
        protected ContainerListener accessibleContainerHandler;
        protected int propertyChangeListenerCount;

        protected AccessibleWindow() {
            super(Window.this);
            this.accessibleComponentHandler = null;
            this.accessibleContainerHandler = null;
            this.propertyChangeListenerCount = 0;
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            if (this.propertyChangeListenerCount++ == 0) {
                this.accessibleContainerHandler = new AccessibleContainerHandler();
                Window.this.addContainerListener(this.accessibleContainerHandler);
                this.accessibleComponentHandler = new AccessibleComponentHandler();
                Window.this.addComponentListener(this.accessibleComponentHandler);
            }
            super.addPropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            if (--this.propertyChangeListenerCount == 0) {
                Window.this.removeComponentListener(this.accessibleComponentHandler);
                this.accessibleComponentHandler = null;
                Window.this.removeContainerListener(this.accessibleContainerHandler);
                this.accessibleContainerHandler = null;
            }
            super.removePropertyChangeListener(listener);
        }

        public Color getBackground() {
            try {
                return new Color(Window.this.unoAccessibleComponent.getBackground());
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setBackground(Color c) {
        }

        public Color getForeground() {
            try {
                return new Color(Window.this.unoAccessibleComponent.getForeground());
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setForeground(Color c) {
        }

        public Cursor getCursor() {
            return null;
        }

        public void setCursor(Cursor cursor) {
        }

        public Font getFont() {
            return null;
        }

        public void setFont(Font f) {
        }

        public FontMetrics getFontMetrics(Font f) {
            return null;
        }

        public boolean isEnabled() {
            return Window.this.isEnabled();
        }

        public void setEnabled(boolean b) {
        }

        public boolean isVisible() {
            return Window.this.isVisible();
        }

        public void setVisible(boolean b) {
        }

        public boolean isShowing() {
            return Window.this.isShowing();
        }

        public boolean contains(java.awt.Point p) {
            try {
                return Window.this.unoAccessibleComponent.containsPoint(new Point(p.x, p.y));
            }
            catch (RuntimeException e) {
                return false;
            }
        }

        public java.awt.Point getLocationOnScreen() {
            try {
                Point unoPoint = Window.this.unoAccessibleComponent.getLocationOnScreen();
                return new java.awt.Point(unoPoint.X, unoPoint.Y);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public java.awt.Point getLocation() {
            try {
                Point unoPoint = Window.this.unoAccessibleComponent.getLocationOnScreen();
                return new java.awt.Point(unoPoint.X, unoPoint.Y);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setLocation(java.awt.Point p) {
        }

        public java.awt.Rectangle getBounds() {
            try {
                Rectangle unoRect = Window.this.unoAccessibleComponent.getBounds();
                return new java.awt.Rectangle(unoRect.X, unoRect.Y, unoRect.Width, unoRect.Height);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setBounds(java.awt.Rectangle r) {
        }

        public Dimension getSize() {
            try {
                Size unoSize = Window.this.unoAccessibleComponent.getSize();
                return new Dimension(unoSize.Width, unoSize.Height);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public void setSize(Dimension d) {
        }

        public Accessible getAccessibleAt(java.awt.Point p) {
            try {
                Component c = AccessibleObjectFactory.getAccessibleComponent(Window.this.unoAccessibleComponent.getAccessibleAtPoint(new Point(p.x, p.y)));
                return (Accessible)((Object)c);
            }
            catch (RuntimeException e) {
                return null;
            }
        }

        public boolean isFocusTraversable() {
            return Window.this.isFocusable();
        }

        public void requestFocus() {
            Window.this.unoAccessibleComponent.grabFocus();
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            protected AccessibleContainerHandler() {
            }

            public void componentAdded(ContainerEvent e) {
                Component c = e.getChild();
                if (c != null && c instanceof Accessible) {
                    AccessibleWindow.this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)c)).getAccessibleContext());
                }
            }

            public void componentRemoved(ContainerEvent e) {
                Component c = e.getChild();
                if (c != null && c instanceof Accessible) {
                    AccessibleWindow.this.firePropertyChange("AccessibleChild", ((Accessible)((Object)c)).getAccessibleContext(), null);
                }
            }
        }

        protected class AccessibleComponentHandler
        implements ComponentListener {
            protected AccessibleComponentHandler() {
            }

            public void componentHidden(ComponentEvent e) {
                AccessibleWindow.this.firePropertyChange("AccessibleState", AccessibleState.VISIBLE, null);
            }

            public void componentShown(ComponentEvent e) {
                AccessibleWindow.this.firePropertyChange("AccessibleState", null, AccessibleState.VISIBLE);
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentResized(ComponentEvent e) {
            }
        }
    }

    protected class AccessibleWindowListener
    implements XAccessibleEventListener {
        protected AccessibleWindowListener() {
        }

        protected void setComponentState(short state, boolean enable) {
            switch (state) {
                case 13: {
                    Window.this.postWindowEvent(enable ? 203 : 204);
                    break;
                }
                case 25: 
                case 30: {
                    Window.this.setVisible(enable);
                    break;
                }
            }
        }

        protected void handleNameChangedEvent(Object any) {
            try {
                AccessibleContext ac = Window.this.accessibleContext;
                if (ac != null) {
                    ac.setAccessibleName(AnyConverter.toString((Object)any));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleDescriptionChangedEvent(Object any) {
            try {
                if (Window.this.accessibleContext != null) {
                    Window.this.accessibleContext.setAccessibleDescription(AnyConverter.toString((Object)any));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleStateChangedEvent(Object any1, Object any2) {
            try {
                if (AnyConverter.isShort((Object)any1)) {
                    this.setComponentState(AnyConverter.toShort((Object)any1), false);
                }
                if (AnyConverter.isShort((Object)any2)) {
                    this.setComponentState(AnyConverter.toShort((Object)any2), true);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        protected void handleVisibleDataEvent() {
            AccessibleContext ac = Window.this.accessibleContext;
            if (ac != null) {
                ac.firePropertyChange("AccessibleVisibleData", null, null);
            }
        }

        public void notifyEvent(AccessibleEventObject event) {
            switch (event.EventId) {
                case 1: {
                    this.handleNameChangedEvent(event.NewValue);
                    break;
                }
                case 2: {
                    this.handleDescriptionChangedEvent(event.NewValue);
                    break;
                }
                case 4: {
                    this.handleStateChangedEvent(event.OldValue, event.NewValue);
                    break;
                }
                case 7: {
                    if (AnyConverter.isObject((Object)event.OldValue)) {
                        AccessibleObjectFactory.removeChild(Window.this, event.OldValue);
                        break;
                    }
                    if (!AnyConverter.isObject((Object)event.NewValue)) break;
                    AccessibleObjectFactory.addChild((Container)Window.this, event.NewValue);
                    break;
                }
                case 6: 
                case 10: {
                    this.handleVisibleDataEvent();
                    break;
                }
                default: {
                    System.out.println(this + ": unhandled accessibility event id=" + event.EventId);
                }
            }
        }

        public void disposing(EventObject eventObject) {
        }
    }
}

