/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility.logging;

import com.sun.star.accessibility.AccessibleEventObject;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEventBroadcaster;
import com.sun.star.accessibility.XAccessibleEventListener;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import java.awt.Component;
import java.util.Hashtable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;

public class XAccessibleEventLog
implements XAccessibleEventListener {
    private static XAccessibleEventLog theEventListener = null;
    private static Hashtable<String, Component> proxyList = new Hashtable();

    private static XAccessibleEventListener get() {
        if (theEventListener == null) {
            theEventListener = new XAccessibleEventLog();
        }
        return theEventListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addEventListener(XAccessibleContext xac, Component c) {
        XAccessibleEventBroadcaster broadcaster = (XAccessibleEventBroadcaster)UnoRuntime.queryInterface(XAccessibleEventBroadcaster.class, (Object)xac);
        if (broadcaster != null) {
            broadcaster.addAccessibleEventListener(XAccessibleEventLog.get());
            Hashtable<String, Component> hashtable = proxyList;
            synchronized (hashtable) {
                proxyList.put(UnoRuntime.generateOid((Object)xac), c);
            }
        }
    }

    public void disposing(EventObject eventObject) {
    }

    public void notifyEvent(AccessibleEventObject accessibleEventObject) {
        switch (accessibleEventObject.EventId) {
            case 5: {
                XAccessibleEventLog.logMessage(accessibleEventObject.Source, "Retrieved active descendant event.");
                break;
            }
            case 4: {
                this.logStateChange(accessibleEventObject.Source, accessibleEventObject.OldValue, accessibleEventObject.NewValue);
                break;
            }
            case 7: {
                XAccessibleEventLog.logMessage(accessibleEventObject.Source, "Retrieved children event.");
                break;
            }
            case 6: {
                XAccessibleEventLog.logMessage(accessibleEventObject.Source, "Retrieved boundrect changed event.");
                break;
            }
            case 10: {
                XAccessibleEventLog.logMessage(accessibleEventObject.Source, "Retrieved visible data changed event.");
                break;
            }
            case 8: {
                XAccessibleEventLog.logMessage(accessibleEventObject.Source, "Retrieved invalidate children event.");
                break;
            }
        }
    }

    public void logStateChange(Object o, Object any1, Object any2) {
        try {
            if (AnyConverter.isShort((Object)any1)) {
                this.logStateChange(o, AnyConverter.toShort((Object)any1), " is no longer ");
            }
            if (AnyConverter.isShort((Object)any2)) {
                this.logStateChange(o, AnyConverter.toShort((Object)any2), " is now ");
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
    }

    public void logStateChange(Object o, short n, String s) {
        switch (n) {
            case 1: {
                XAccessibleEventLog.logMessage(o, s + AccessibleState.ACTIVE);
                break;
            }
            case 2: {
                XAccessibleEventLog.logMessage(o, s + AccessibleState.ARMED);
                break;
            }
            case 4: {
                XAccessibleEventLog.logMessage(o, s + AccessibleState.CHECKED);
                break;
            }
            case 7: {
                XAccessibleEventLog.logMessage(o, s + AccessibleState.ENABLED);
                break;
            }
            case 11: {
                XAccessibleEventLog.logMessage(o, s + AccessibleState.FOCUSED);
                break;
            }
            case 20: {
                XAccessibleEventLog.logMessage(o, s + AccessibleState.PRESSED);
                break;
            }
            case 23: {
                XAccessibleEventLog.logMessage(o, s + AccessibleState.SELECTED);
                break;
            }
            case 24: {
                XAccessibleEventLog.logMessage(o, s + "sensitive");
                break;
            }
            case 25: {
                XAccessibleEventLog.logMessage(o, s + AccessibleState.SHOWING);
                break;
            }
            case 30: {
                XAccessibleEventLog.logMessage(o, s + AccessibleState.VISIBLE);
                break;
            }
            default: {
                XAccessibleEventLog.logMessage(o, s + "??? (FIXME)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void logMessage(Object o, String s) {
        XAccessibleContext xac = (XAccessibleContext)UnoRuntime.queryInterface(XAccessibleContext.class, (Object)o);
        if (xac != null) {
            String oid = UnoRuntime.generateOid((Object)xac);
            Hashtable<String, Component> hashtable = proxyList;
            synchronized (hashtable) {
                XAccessibleEventLog.logMessage((Accessible)((Object)proxyList.get(oid)), s);
            }
        } else {
            System.err.println("*** Warning *** event source does not implement XAccessibleContext");
        }
    }

    protected static void logMessage(Accessible a, String s) {
        if (a != null) {
            XAccessibleEventLog.logMessage(a.getAccessibleContext(), s);
        } else {
            XAccessibleEventLog.logMessage(s);
        }
    }

    protected static void logMessage(AccessibleContext ac, String s) {
        if (ac != null) {
            XAccessibleEventLog.logMessage("[" + ac.getAccessibleRole() + "] " + ac.getAccessibleName() + ": " + s);
        } else {
            XAccessibleEventLog.logMessage(s);
        }
    }

    protected static void logMessage(String s) {
        System.err.println(s);
    }
}

