/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.java.accessibility.logging;

import com.sun.star.accessibility.TextSegment;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.awt.Point;
import com.sun.star.awt.Rectangle;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import org.openoffice.java.accessibility.AccessibleRoleAdapter;

public class XAccessibleTextLog
implements XAccessibleText {
    private XAccessibleText unoObject;
    private String name = "[Unknown] NoName";

    public XAccessibleTextLog(XAccessibleText xAccessibleText) {
        this.unoObject = xAccessibleText;
        this.setName(xAccessibleText);
    }

    private void setName(XAccessibleText xAccessibleText) {
        try {
            XAccessibleContext unoAccessibleContext = (XAccessibleContext)UnoRuntime.queryInterface(XAccessibleContext.class, (Object)xAccessibleText);
            if (unoAccessibleContext != null) {
                this.name = "[" + AccessibleRoleAdapter.getAccessibleRole(unoAccessibleContext.getAccessibleRole()) + "] " + unoAccessibleContext.getAccessibleName() + ": ";
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private String getPartString(short s) {
        String part = "INVALID";
        switch (s) {
            case 1: {
                part = "CHARACTER";
                break;
            }
            case 2: {
                part = "WORD";
                break;
            }
            case 3: {
                part = "SENTENCE";
                break;
            }
            case 5: {
                part = "LINE";
                break;
            }
            case 7: {
                part = "ATTRIBUTE_RUN";
                break;
            }
        }
        return part;
    }

    private String dumpTextSegment(TextSegment ts) {
        if (ts != null) {
            return "(" + ts.SegmentStart + "," + ts.SegmentEnd + "," + ts.SegmentText + ")";
        }
        return "NULL";
    }

    public boolean copyText(int param, int param1) throws IndexOutOfBoundsException {
        return this.unoObject.copyText(param, param1);
    }

    public int getCaretPosition() {
        int pos = this.unoObject.getCaretPosition();
        System.err.println(this.name + "getCaretPosition() returns " + pos);
        return pos;
    }

    public char getCharacter(int param) throws IndexOutOfBoundsException {
        return this.unoObject.getCharacter(param);
    }

    public PropertyValue[] getCharacterAttributes(int param, String[] str) throws IndexOutOfBoundsException {
        return this.unoObject.getCharacterAttributes(param, str);
    }

    public Rectangle getCharacterBounds(int param) throws IndexOutOfBoundsException {
        try {
            Rectangle r = this.unoObject.getCharacterBounds(param);
            System.err.println(this.name + "getCharacterBounds(" + param + ") returns (" + r.X + "," + r.Y + "," + r.Width + "," + r.Height + ")");
            return r;
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("IndexOutOufBoundsException caught for " + this.name + "getCharacterBounds(" + param + ")");
            throw e;
        }
    }

    public int getCharacterCount() {
        return this.unoObject.getCharacterCount();
    }

    public int getIndexAtPoint(Point point) {
        try {
            int index = this.unoObject.getIndexAtPoint(point);
            System.err.println(this.name + "getIndexAtPoint(" + point.X + ", " + point.Y + ") returns " + index);
            return index;
        }
        catch (RuntimeException e) {
            System.err.println(this.name + "RuntimeException caught for getIndexAtPoint(" + point.X + ", " + point.Y + ")");
            System.err.println(e.getMessage());
            throw e;
        }
    }

    public String getSelectedText() {
        return this.unoObject.getSelectedText();
    }

    public int getSelectionEnd() {
        return this.unoObject.getSelectionEnd();
    }

    public int getSelectionStart() {
        return this.unoObject.getSelectionStart();
    }

    public String getText() {
        return this.unoObject.getText();
    }

    public TextSegment getTextAtIndex(int param, short param1) throws IndexOutOfBoundsException, IllegalArgumentException {
        try {
            TextSegment ts = this.unoObject.getTextAtIndex(param, param1);
            System.err.println(this.name + "getTextAtIndex(" + this.getPartString(param1) + "," + param + ") returns " + this.dumpTextSegment(ts));
            return ts;
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("IndexOutOufBoundsException caught for " + this.name + " getTextAtIndex(" + this.getPartString(param1) + "," + param1 + ")");
            throw e;
        }
        catch (IllegalArgumentException e) {
            System.err.println("IllegalArgumentException caught for " + this.name + " getTextAtIndex(" + this.getPartString(param1) + "," + param + ")");
            throw e;
        }
    }

    public TextSegment getTextBeforeIndex(int param, short param1) throws IndexOutOfBoundsException, IllegalArgumentException {
        try {
            TextSegment ts = this.unoObject.getTextBeforeIndex(param, param1);
            System.err.println(this.name + " getTextBeforeIndex(" + this.getPartString(param1) + "," + param + ") returns " + this.dumpTextSegment(ts));
            return ts;
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("IndexOutOufBoundsException caught for " + this.name + " getTextBeforeIndex(" + this.getPartString(param1) + "," + param1 + ")");
            throw e;
        }
        catch (IllegalArgumentException e) {
            System.err.println("IllegalArgumentException caught for " + this.name + " getTextBeforeIndex(" + this.getPartString(param1) + "," + param + ")");
            throw e;
        }
    }

    public TextSegment getTextBehindIndex(int param, short param1) throws IndexOutOfBoundsException, IllegalArgumentException {
        try {
            TextSegment ts = this.unoObject.getTextBehindIndex(param, param1);
            System.err.println(this.name + " getTextBehindIndex(" + this.getPartString(param1) + "," + param + ") returns " + this.dumpTextSegment(ts));
            return ts;
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("IndexOutOufBoundsException caught for " + this.name + " getTextBehindIndex(" + this.getPartString(param1) + "," + param1 + ")");
            throw e;
        }
        catch (IllegalArgumentException e) {
            System.err.println("IllegalArgumentException caught for " + this.name + " getTextBehindIndex(" + this.getPartString(param1) + "," + param + ")");
            throw e;
        }
    }

    public String getTextRange(int param, int param1) throws IndexOutOfBoundsException {
        return this.unoObject.getTextRange(param, param1);
    }

    public boolean setCaretPosition(int param) throws IndexOutOfBoundsException {
        return this.unoObject.setCaretPosition(param);
    }

    public boolean setSelection(int param, int param1) throws IndexOutOfBoundsException {
        return this.unoObject.setSelection(param, param1);
    }
}

