/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.table;

import com.sun.star.awt.TextEvent;
import com.sun.star.awt.XTextListener;
import com.sun.star.beans.PropertyValue;
import com.sun.star.lang.XInitialization;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.sdbc.SQLException;
import com.sun.star.task.XJobExecutor;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.wizards.common.Configuration;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.JavaTools;
import com.sun.star.wizards.common.NamedValueCollection;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.db.DatabaseObjectWizard;
import com.sun.star.wizards.db.TableDescriptor;
import com.sun.star.wizards.table.FieldDescription;
import com.sun.star.wizards.table.FieldFormatter;
import com.sun.star.wizards.table.Finalizer;
import com.sun.star.wizards.table.PrimaryKeyHandler;
import com.sun.star.wizards.table.ScenarioSelector;
import com.sun.star.wizards.ui.UnoDialog;
import java.util.HashMap;

public class TableWizard
extends DatabaseObjectWizard
implements XTextListener {
    static String slblFields;
    static String slblSelFields;
    Finalizer curFinalizer;
    ScenarioSelector curScenarioSelector;
    FieldFormatter curFieldFormatter;
    PrimaryKeyHandler curPrimaryKeyHandler;
    String sMsgWizardName = PropertyNames.EMPTY_STRING;
    public HashMap<String, FieldDescription> fielditems;
    int wizardmode;
    String tablename;
    String serrToManyFields;
    String serrTableNameexists;
    String scomposedtablename;
    TableDescriptor curTableDescriptor;
    public static final int SONULLPAGE = 0;
    public static final int SOMAINPAGE = 1;
    public static final int SOFIELDSFORMATPAGE = 2;
    public static final int SOPRIMARYKEYPAGE = 3;
    public static final int SOFINALPAGE = 4;
    private String sMsgColumnAlreadyExists = PropertyNames.EMPTY_STRING;
    String[] WizardHeaderText = new String[8];
    private String m_tableName;

    public TableWizard(XMultiServiceFactory xMSF, PropertyValue[] i_wizardContext) {
        super(xMSF, 41200, i_wizardContext);
        super.addResourceHandler("TableWizard", "dbw");
        String sTitle = this.m_oResource.getResText(2601);
        Helper.setUnoPropertyValues(this.xDialogModel, new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_MOVEABLE, PropertyNames.PROPERTY_NAME, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_TITLE, PropertyNames.PROPERTY_WIDTH}, new Object[]{218, Boolean.TRUE, "DialogTable", 102, 41, 1, new Short(0), sTitle, 330});
        this.drawNaviBar();
        this.fielditems = new HashMap();
        if (this.getTableResources()) {
            this.setRightPaneHeaders(this.m_oResource, 2608, 4);
        }
    }

    protected void leaveStep(int nOldStep, int nNewStep) {
        switch (nOldStep) {
            case 1: {
                this.curScenarioSelector.addColumnsToDescriptor();
                break;
            }
            case 2: {
                this.curFieldFormatter.updateColumnofColumnDescriptor();
                String[] sfieldnames = this.curFieldFormatter.getFieldNames();
                super.setStepEnabled(2, sfieldnames.length > 0);
                this.curScenarioSelector.setSelectedFieldNames(sfieldnames);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
        }
    }

    protected void enterStep(int nOldStep, int nNewStep) {
        switch (nNewStep) {
            case 1: {
                break;
            }
            case 2: {
                this.curFieldFormatter.initialize(this.curTableDescriptor, this.curScenarioSelector.getSelectedFieldNames());
                break;
            }
            case 3: {
                this.curPrimaryKeyHandler.initialize();
                break;
            }
            case 4: {
                this.curFinalizer.initialize(this.curScenarioSelector.getFirstTableName());
                break;
            }
        }
    }

    public boolean iscompleted(int _ndialogpage) {
        switch (_ndialogpage) {
            case 1: {
                return this.curScenarioSelector.iscompleted();
            }
            case 2: {
                return this.curFieldFormatter.iscompleted();
            }
            case 3: {
                if (this.curPrimaryKeyHandler != null) {
                    return this.curPrimaryKeyHandler.iscompleted();
                }
            }
            case 4: {
                return this.curFinalizer.iscompleted();
            }
        }
        return false;
    }

    public void setcompleted(int _ndialogpage, boolean _biscompleted) {
        boolean bScenarioiscompleted = _biscompleted;
        boolean bFieldFormatsiscompleted = _biscompleted;
        boolean bPrimaryKeysiscompleted = _biscompleted;
        boolean bFinalPageiscompleted = _biscompleted;
        if (_ndialogpage == 1) {
            this.curFinalizer.initialize(this.curScenarioSelector.getFirstTableName());
        } else {
            bScenarioiscompleted = this.iscompleted(1);
        }
        if (_ndialogpage != 2 && !(bFieldFormatsiscompleted = this.iscompleted(2))) {
            bFieldFormatsiscompleted = bScenarioiscompleted;
        }
        if (_ndialogpage != 3 && this.curPrimaryKeyHandler != null) {
            bPrimaryKeysiscompleted = this.iscompleted(3);
        }
        if (_ndialogpage != 4) {
            bFinalPageiscompleted = this.iscompleted(4);
        }
        if (bScenarioiscompleted) {
            super.setStepEnabled(2, true);
            super.setStepEnabled(3, true);
            if (bPrimaryKeysiscompleted) {
                super.enablefromStep(4, true);
                super.enableFinishButton(bFinalPageiscompleted);
            } else {
                super.enablefromStep(4, false);
                this.enableNextButton(false);
            }
        } else if (_ndialogpage == 2) {
            super.enablefromStep(super.getCurrentStep() + 1, this.iscompleted(2));
        } else {
            super.enablefromStep(super.getCurrentStep() + 1, false);
        }
    }

    public void buildSteps() {
        this.curScenarioSelector = new ScenarioSelector(this, this.curTableDescriptor, slblFields, slblSelFields);
        this.curFieldFormatter = new FieldFormatter(this, this.curTableDescriptor);
        if (this.curTableDescriptor.supportsPrimaryKeys()) {
            this.curPrimaryKeyHandler = new PrimaryKeyHandler(this, this.curTableDescriptor);
        }
        this.curFinalizer = new Finalizer(this, this.curTableDescriptor);
        this.enableNavigationButtons(false, false, false);
    }

    public boolean createTable() {
        String[] keyfieldnames;
        boolean bIsSuccessfull = true;
        boolean bTableCreated = false;
        String schemaname = this.curFinalizer.getSchemaName();
        String catalogname = this.curFinalizer.getCatalogName();
        if (this.curTableDescriptor.supportsPrimaryKeys() && (keyfieldnames = this.curPrimaryKeyHandler.getPrimaryKeyFields(this.curTableDescriptor)) != null && keyfieldnames.length > 0) {
            boolean bIsAutoIncrement = this.curPrimaryKeyHandler.isAutoIncremented();
            bIsSuccessfull = this.curTableDescriptor.createTable(catalogname, schemaname, this.tablename, keyfieldnames, bIsAutoIncrement, this.curScenarioSelector.getSelectedFieldNames());
            bTableCreated = true;
        }
        if (!bTableCreated) {
            bIsSuccessfull = this.curTableDescriptor.createTable(catalogname, schemaname, this.tablename, this.curScenarioSelector.getSelectedFieldNames());
        }
        if (!bIsSuccessfull && this.curPrimaryKeyHandler.isAutomaticMode()) {
            this.curTableDescriptor.dropColumnbyName(this.curPrimaryKeyHandler.getAutomaticFieldName());
        }
        return bIsSuccessfull;
    }

    public boolean finishWizard() {
        super.switchToStep(super.getCurrentStep(), 4);
        this.tablename = this.curFinalizer.getTableName(this.curScenarioSelector.getFirstTableName());
        this.scomposedtablename = this.curFinalizer.getComposedTableName(this.tablename);
        if (this.curTableDescriptor.isSQL92CheckEnabled()) {
            Desktop.removeSpecialCharacters(this.curTableDescriptor.xMSF, Configuration.getLocale(this.curTableDescriptor.xMSF), this.tablename);
        }
        if (this.tablename.length() > 0) {
            if (!this.curTableDescriptor.hasTableByName(this.scomposedtablename)) {
                this.wizardmode = this.curFinalizer.finish();
                if (this.createTable()) {
                    boolean editTableDesign = this.wizardmode == Finalizer.MODIFYTABLEMODE;
                    this.loadSubComponent(0, this.curTableDescriptor.getComposedTableName(), editTableDesign);
                    this.m_tableName = this.curTableDescriptor.getComposedTableName();
                    this.xDialog.endExecute();
                    return true;
                }
            } else {
                String smessage = JavaTools.replaceSubString(this.serrTableNameexists, this.tablename, "%TABLENAME");
                super.showMessageBox("WarningBox", 0x400000, smessage);
                this.curFinalizer.setFocusToTableNameControl();
            }
        }
        return false;
    }

    private void callFormWizard() {
        try {
            Object oFormWizard = this.xMSF.createInstance("com.sun.star.wizards.form.CallFormWizard");
            NamedValueCollection wizardContext = new NamedValueCollection();
            wizardContext.put(PropertyNames.ACTIVE_CONNECTION, this.curTableDescriptor.DBConnection);
            wizardContext.put("DataSource", this.curTableDescriptor.getDataSource());
            wizardContext.put(PropertyNames.COMMAND_TYPE, 0);
            wizardContext.put(PropertyNames.COMMAND, this.scomposedtablename);
            wizardContext.put("DocumentUI", this.m_docUI);
            XInitialization xInitialization = (XInitialization)UnoRuntime.queryInterface(XInitialization.class, (Object)oFormWizard);
            xInitialization.initialize((Object[])wizardContext.getPropertyValues());
            XJobExecutor xJobExecutor = (XJobExecutor)UnoRuntime.queryInterface(XJobExecutor.class, (Object)oFormWizard);
            xJobExecutor.trigger(PropertyNames.START);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void cancelWizard() {
        this.xDialog.endExecute();
    }

    public void insertFormRelatedSteps() {
        this.addRoadmap();
        int i = 0;
        i = this.insertRoadmapItem(0, true, this.m_oResource.getResText(2602), 1);
        i = this.insertRoadmapItem(i, false, this.m_oResource.getResText(2603), 2);
        if (this.curTableDescriptor.supportsPrimaryKeys()) {
            i = this.insertRoadmapItem(i, false, this.m_oResource.getResText(2604), 3);
        }
        i = this.insertRoadmapItem(i, false, this.m_oResource.getResText(2605), 4);
        this.setRoadmapInteractive(true);
        this.setRoadmapComplete(true);
        this.setCurrentRoadmapItemID((short)1);
    }

    public String startTableWizard() {
        try {
            this.curTableDescriptor = new TableDescriptor(this.xMSF, this.xWindow, this.sMsgColumnAlreadyExists);
            if (this.curTableDescriptor.getConnection(this.m_wizardContext)) {
                this.buildSteps();
                this.createWindowPeer();
                this.curTableDescriptor.setWindowPeer(this.xControl.getPeer());
                this.insertFormRelatedSteps();
                short RetValue = this.executeDialog();
                this.xComponent.dispose();
                if (RetValue == 0) {
                    if (this.wizardmode == Finalizer.STARTFORMWIZARDMODE) {
                        this.callFormWizard();
                    }
                    return this.m_tableName;
                }
            }
        }
        catch (Exception jexception) {
            jexception.printStackTrace(System.err);
        }
        return PropertyNames.EMPTY_STRING;
    }

    public boolean getTableResources() {
        this.sMsgWizardName = this.m_oResource.getResText(2601);
        slblFields = this.m_oResource.getResText(2619);
        slblSelFields = this.m_oResource.getResText(2625);
        this.serrToManyFields = this.m_oResource.getResText(2647);
        this.serrTableNameexists = this.m_oResource.getResText(2648);
        this.sMsgColumnAlreadyExists = this.m_oResource.getResText(2651);
        return true;
    }

    public boolean verifyfieldcount(int _icount) {
        try {
            int maxfieldcount = this.curTableDescriptor.getMaxColumnsInTable();
            if (_icount >= maxfieldcount - 1) {
                String smessage = this.serrToManyFields;
                smessage = JavaTools.replaceSubString(smessage, String.valueOf(maxfieldcount), "%COUNT");
                this.showMessageBox("ErrorBox", 0x400000, smessage);
                return false;
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.err);
        }
        return true;
    }

    public void textChanged(TextEvent aTextEvent) {
        if (this.curTableDescriptor.isSQL92CheckEnabled()) {
            Object otextcomponent = UnoDialog.getModel(aTextEvent.Source);
            String sName = (String)Helper.getUnoPropertyValue(otextcomponent, "Text");
            sName = Desktop.removeSpecialCharacters(this.curTableDescriptor.xMSF, Configuration.getLocale(this.curTableDescriptor.xMSF), sName);
            Helper.setUnoPropertyValue(otextcomponent, "Text", sName);
        }
    }
}

